/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.python;

import commvault.tools.python.PythonUtil;
import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class RuntimeExecutor {
    private String output;
    private String error;

    public int execute(ProcessBuilder processBuilder, long l) throws InterruptedException, IOException, TimeoutException {
        return this.monitorProcess(processBuilder.start(), l);
    }

    public int execute(String string, long l) throws InterruptedException, IOException, TimeoutException {
        Runtime runtime = Runtime.getRuntime();
        return this.monitorProcess(runtime.exec(string), l);
    }

    public int monitorProcess(Process process, long l) throws InterruptedException, IOException, TimeoutException {
        Worker worker = new Worker(process);
        worker.start();
        try {
            worker.join(l);
            if (worker.exit != null) {
                this.output = PythonUtil.streamToString(process.getInputStream());
                this.error = PythonUtil.streamToString(process.getErrorStream());
                int n = worker.exit;
                return n;
            }
            try {
                throw new TimeoutException("timed out");
            }
            catch (InterruptedException interruptedException) {
                worker.interrupt();
                Thread.currentThread().interrupt();
                throw interruptedException;
            }
        }
        finally {
            process.destroy();
        }
    }

    public String getOutput() {
        return this.output;
    }

    public String getError() {
        return this.error;
    }

    private class Worker
    extends Thread {
        private final Process process;
        private Integer exit;

        private Worker(Process process) {
            this.process = process;
        }

        @Override
        public void run() {
            try {
                this.exit = this.process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

