/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.generator;

import commvault.tools.generator.AnnotationDefValues;
import commvault.tools.generator.ClassDef;
import commvault.tools.generator.ConstantDef;
import commvault.tools.generator.ConstantItem;
import commvault.tools.generator.FieldDef;
import commvault.tools.generator.JavaCharStream;
import commvault.tools.generator.MessageParserConstants;
import commvault.tools.generator.MessageParserTokenManager;
import commvault.tools.generator.NameSpace;
import commvault.tools.generator.ParseException;
import commvault.tools.generator.SubSystems;
import commvault.tools.generator.Token;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MessageParser
implements MessageParserConstants {
    static boolean unix = false;
    static HashMap<String, NameSpace> nsMap;
    static NameSpace annotNsp;
    NameSpace root = new NameSpace();
    String path = null;
    static String annotationPath;
    boolean withMessage = false;
    boolean primitive = false;
    boolean list = false;
    boolean map = false;
    ClassDef def;
    ConstantDef cDef;
    FieldDef fDef;
    int n;
    String flagType;
    String flagValue;
    AnnotationDefValues annotation = null;
    int enumValue;
    static String langType;
    List<AnnotationDefValues> listOfAnnotations;
    public MessageParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[55];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[4];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public MessageParser(String string) throws Exception {
        this(System.in);
        this.path = string;
        this.ReInit(new FileInputStream(new File(string)));
    }

    public static void setOSType(String string) {
        unix = string.equalsIgnoreCase("unix");
    }

    public static NameSpace parse(String string, int n) throws Exception {
        MessageParser messageParser = new MessageParser(string);
        String string2 = new File(string).getName();
        String string3 = string2.substring(0, string2.lastIndexOf("."));
        if (nsMap.containsKey(string3)) {
            return nsMap.get(string3);
        }
        if (!messageParser.root.canParse(string3)) {
            return messageParser.root;
        }
        messageParser.root.setName(string3);
        messageParser.root.id = n;
        try {
            messageParser.CompilationUnit();
            nsMap.put(string3, messageParser.root);
            System.out.println("Parser successfully parsed subsystem:" + string3 + " with tagId:" + n);
            boolean bl = true;
            for (ClassDef classDef : messageParser.root.getClasses()) {
                if (classDef.isDeclared()) continue;
                bl = false;
                System.out.println("Definition of class " + classDef.name + " not found");
            }
            if (!bl) {
                System.exit(-1);
            }
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            System.out.println("Parser failed to parse subsystem:" + string3 + " with tagId:" + n);
            System.out.println("Message Parser Version 1.1:  Encountered errors during parse.");
            System.exit(-1);
        }
        return messageParser.root;
    }

    public static void main(String[] stringArray) {
        MessageParser messageParser;
        if (stringArray.length == 0) {
            System.out.println("Message Parser Version 1.1:  Reading from standard input . . .");
            messageParser = new MessageParser(System.in);
        } else if (stringArray.length == 1) {
            System.out.println("Message Parser Version 1.1:  Reading from file " + stringArray[0] + " . . .");
            try {
                messageParser = new MessageParser(new FileInputStream(stringArray[0]));
                messageParser.path = stringArray[0];
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.out.println("Message Parser Version 1.1:  File " + stringArray[0] + " not found.");
                return;
            }
        } else {
            System.out.println("Message Parser Version 1.1:  Usage is one of:");
            System.out.println("         java MessageParser < inputfile");
            System.out.println("OR");
            System.out.println("         java MessageParser inputfile");
            return;
        }
        try {
            messageParser.CompilationUnit();
            System.out.println("Message Parser Version 1.1:  Message Parser program parsed successfully.");
        }
        catch (ParseException parseException) {
            System.out.println(parseException.getMessage());
            System.out.println("Message Parser Version 1.1:  Encountered errors during parse.");
        }
    }

    public final void CompilationUnit() throws ParseException {
        try {
            if (this.root.id != 27 && annotationPath != null) {
                annotNsp = MessageParser.parse(new File(annotationPath) + "/Annotation.x", 27);
            } else if (this.root.id != 27 && annotNsp == null) {
                annotNsp = MessageParser.parse(new File(this.path).getParent() + "/Annotation.x", 27);
            }
            this.listOfAnnotations = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        block26: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 35: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block26;
                }
            }
            this.ImportDeclaration();
        }
        block27: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block27;
                }
            }
            this.IncludeDeclaration();
        }
        block28: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 17: 
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block28;
                }
            }
            this.functionDeclarationOutsideNameSpace();
        }
        block10 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                this.Annotation();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 63: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block10;
                        }
                    }
                    this.Annotation();
                }
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        if (this.listOfAnnotations != null) {
            this.root.setAnnotations(this.listOfAnnotations);
        }
        this.listOfAnnotations = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        block30: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 17: 
                case 19: 
                case 28: 
                case 29: 
                case 31: 
                case 63: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block30;
                }
            }
            this.TypeDeclaration();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                this.jj_consume_token(43);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        this.jj_consume_token(0);
    }

    public final void ImportDeclaration() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        this.jj_consume_token(35);
        Token token = this.PathName();
        stringBuffer.append(token.image);
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(65);
            token = this.PathName();
            stringBuffer.append("/").append(token.image);
        }
        this.jj_consume_token(66);
        try {
            this.debug("importing: " + new File(this.path).getParent() + "//" + stringBuffer + ".x");
            NameSpace nameSpace = MessageParser.parse(new File(this.path).getParent() + "//" + stringBuffer + ".x", this.root.id);
            this.root.getClasses().addAll(nameSpace.getClasses());
            this.root.getConstants().addAll(nameSpace.getConstants());
            this.root.getIncludes().addAll(nameSpace.getIncludes());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.debug("imported ..." + token.image);
    }

    public final Token PathName() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                token = this.jj_consume_token(53);
                break;
            }
            case 21: {
                token = this.jj_consume_token(21);
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.debug("PathName" + token.image);
        return token;
    }

    public final void IncludeDeclaration() throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        this.jj_consume_token(36);
        Token token = this.PathName();
        stringBuffer.append(token.image);
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 65: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(65);
            token = this.PathName();
            stringBuffer.append("/").append(token.image);
        }
        this.jj_consume_token(66);
        try {
            this.debug("Including ..." + new File(this.path).getParent() + "/" + stringBuffer + ".x");
            NameSpace nameSpace = MessageParser.parse(new File(this.path).getParent() + "/" + stringBuffer + ".x", SubSystems.getTagId(token.image));
            this.root.addInclude(nameSpace);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.debug("imported ..." + token.image);
    }

    public final void TypeDeclaration() throws ParseException {
        this.listOfAnnotations = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 17: 
            case 19: 
            case 28: 
            case 31: 
            case 63: {
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 63: {
                        this.Annotation();
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 63: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[11] = this.jj_gen;
                                    break block4;
                                }
                            }
                            this.Annotation();
                        }
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 28: {
                        this.ClassDeclaration();
                        break block0;
                    }
                    case 31: {
                        this.jj_consume_token(31);
                        this.jj_consume_token(53);
                        this.def = ClassDef.create(this.token.image, this.root, true);
                        this.debug("enum definition name" + this.token.image);
                        this.def.enumType = true;
                        this.def.setComment(this.getComment());
                        if (this.listOfAnnotations != null) {
                            this.def.setAnnotations(this.listOfAnnotations);
                        }
                        this.listOfAnnotations = null;
                        this.EnumBody();
                        break block0;
                    }
                    case 15: 
                    case 17: 
                    case 19: {
                        this.functionDeclarationInNameSpace();
                        break block0;
                    }
                }
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 29: {
                this.ConstantDeclaration();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void ConstantDeclaration() throws ParseException {
        this.jj_consume_token(29);
        this.jj_consume_token(53);
        this.cDef = new ConstantDef();
        this.cDef.setName(this.token.image);
        this.root.getConstants().add(this.cDef);
        this.jj_consume_token(58);
        this.ConstantDef();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 62: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(62);
            this.ConstantDef();
        }
        this.jj_consume_token(59);
        this.cDef.preProcess();
    }

    public final void ConstantDef() throws ParseException {
        ConstantItem constantItem = new ConstantItem();
        ArrayList arrayList = new ArrayList();
        this.jj_consume_token(53);
        constantItem.setName(this.token.image);
        this.jj_consume_token(67);
        this.jj_consume_token(44);
        constantItem.setId(this.token.image);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                this.jj_consume_token(58);
                this.GroupElement(constantItem);
                block6: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 62: {
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(62);
                    this.GroupElement(constantItem);
                }
                this.jj_consume_token(59);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        this.cDef.getConstants().add(constantItem);
    }

    public final void GroupElement(ConstantItem constantItem) throws ParseException {
        boolean bl = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 68: {
                this.jj_consume_token(68);
                bl = true;
                break;
            }
            default: {
                this.jj_la1[18] = this.jj_gen;
            }
        }
        this.jj_consume_token(53);
        if (bl) {
            constantItem.getExceptGroup().add(this.cDef.findConstant(this.token.image));
        } else {
            constantItem.getGroup().add(this.cDef.findConstant(this.token.image));
        }
    }

    public final void ClassDeclaration() throws ParseException {
        Token token = null;
        String string = this.getComment();
        this.jj_consume_token(28);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                token = this.jj_consume_token(44);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
            }
        }
        this.jj_consume_token(53);
        this.def = ClassDef.create(this.token.image, this.root, true);
        if (this.listOfAnnotations != null) {
            this.def.setAnnotations(this.listOfAnnotations);
        }
        this.listOfAnnotations = null;
        this.def.enumType = false;
        this.def.setComment(string);
        if (token != null) {
            this.def.setId(token.image);
        }
        this.debug("class name" + this.token.image);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69: {
                this.TypeParameters();
                break;
            }
            default: {
                this.jj_la1[20] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 32: {
                this.jj_consume_token(32);
                this.ExtendList();
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
            }
        }
        this.ClassBody();
    }

    public final void ExtendList() throws ParseException {
        Token token = this.Name();
        this.def.addBaseClass(ClassDef.create(this.token.image, this.root));
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 62: {
                    break;
                }
                default: {
                    this.jj_la1[22] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(62);
            token = this.Name();
            this.def.addBaseClass(ClassDef.create(this.token.image, this.root));
        }
    }

    public final void EnumBody() throws ParseException {
        this.enumValue = -1;
        this.jj_consume_token(58);
        this.EnumConstant(true);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 62: {
                    break;
                }
                default: {
                    this.jj_la1[23] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(62);
            this.EnumConstant(true);
        }
        this.jj_consume_token(59);
    }

    public final Token EnumConstant(boolean bl) throws ParseException {
        if (bl) {
            this.listOfAnnotations = null;
        }
        ++this.enumValue;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                this.Annotation();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 63: {
                            break;
                        }
                        default: {
                            this.jj_la1[24] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.Annotation();
                }
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        Token token = this.jj_consume_token(53);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                this.jj_consume_token(44);
                this.enumValue = Integer.parseInt(this.token.image);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        if (bl) {
            this.fDef = new FieldDef();
            this.fDef.name = token.image;
            this.fDef.type = ClassDef.ENUM;
            this.fDef.setDafaultValue(new Integer(this.enumValue).toString());
            this.def.addField(this.fDef);
            if (this.listOfAnnotations != null) {
                this.fDef.setAnnotations(this.listOfAnnotations);
            }
            this.listOfAnnotations = null;
        }
        this.debug("enum field" + token.image);
        return token;
    }

    public final void TypeParameters() throws ParseException {
        this.jj_consume_token(69);
        this.jj_consume_token(53);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 62: {
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(62);
            this.jj_consume_token(53);
        }
        this.jj_consume_token(70);
    }

    public final void functionDeclarationOutsideNameSpace() throws ParseException {
        String string = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        string = this.token.image;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (langType.equals(string)) {
            if (this.root.getFunctionContent() == null) {
                this.root.setFunctionContent(this.getFunctionContent());
            } else {
                String string2 = new String();
                string2 = this.root.getFunctionContent();
                string2 = string2 + "\n";
                string2 = string2 + this.getFunctionContent();
                this.root.setFunctionContent(string2);
            }
        }
    }

    public final void functionDeclarationInNameSpace() throws ParseException {
        String string = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        string = this.token.image;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (langType.equals(string)) {
            if (this.root.getFunctionContentWithIn() == null) {
                this.root.setFunctionContentWithIn(this.getFunctionContent());
            } else {
                String string2 = new String();
                string2 = this.root.getFunctionContentWithIn();
                string2 = string2 + "\n";
                string2 = string2 + this.getFunctionContent();
                this.root.setFunctionContentWithIn(string2);
            }
        }
    }

    public final void functionDeclaration() throws ParseException {
        String string = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        string = this.token.image;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 18: {
                this.jj_consume_token(18);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (langType.equals(string)) {
            if (this.def.getFunctionContent() == null) {
                this.def.setFunctionContent(this.getFunctionContent());
            } else {
                String string2 = new String();
                string2 = this.def.getFunctionContent();
                string2 = string2 + "\n";
                string2 = string2 + this.getFunctionContent();
                this.def.setFunctionContent(string2);
            }
        }
    }

    public final void ClassBody() throws ParseException {
        block8: {
            this.jj_consume_token(58);
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 15: 
                    case 17: 
                    case 19: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 30: 
                    case 34: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 53: 
                    case 63: 
                    case 71: {
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 30: 
                    case 34: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 53: 
                    case 63: 
                    case 71: {
                        this.ClassBodyDeclaration();
                        continue block7;
                    }
                    case 15: 
                    case 17: 
                    case 19: {
                        this.functionDeclaration();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[35] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(59);
        this.n = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void ClassBodyDeclaration() throws ParseException {
        Token token = null;
        String string = null;
        this.fDef = new FieldDef();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<Token> arrayList = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                this.Annotation();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 63: {
                            break;
                        }
                        default: {
                            this.jj_la1[36] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.Annotation();
                }
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: {
                this.FieldFlag();
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        Token token2 = this.Type();
        bl = this.list;
        if (bl) {
            token = this.TypeArguments();
        }
        if (bl2 = this.map) {
            arrayList = this.MapArguments();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 64: {
                this.jj_consume_token(64);
                this.fDef.setRef(true);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        Token token3 = this.jj_consume_token(53);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                string = this.VariableInitializer(null);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
        this.fDef.comment = this.getComment();
        if (token2.image.equals("wstring") && unix) {
            token2.image = "string";
        }
        if (bl && token.image.equals("wstring") && unix) {
            token.image = "string";
        }
        this.fDef.type = ClassDef.create(token2.image, this.root);
        this.fDef.templateType = bl ? ClassDef.create(token.image, this.root) : null;
        this.fDef.name = token3.image;
        this.fDef.setDafaultValue(string);
        this.fDef.setFlagType(this.flagType);
        this.fDef.setFlagValue(this.flagValue);
        if (this.flagType != null && this.flagType.equals("GenPath")) {
            this.root.getDotXPathFields().add(this.fDef);
        }
        if (this.listOfAnnotations != null) {
            this.fDef.setAnnotations(this.listOfAnnotations);
        }
        this.def.addField(this.fDef);
        if (!this.fDef.isPrimitive()) {
            ++this.n;
            this.fDef.index = this.n;
        }
        if (bl2) {
            if (arrayList == null || arrayList.size() != 2) throw new Error("Invalid map type. Field : " + this.fDef.name);
            this.fDef.mapKeyType = ClassDef.create(arrayList.get((int)0).image, this.root);
            this.fDef.mapValueType = ClassDef.create(arrayList.get((int)1).image, this.root);
        } else {
            this.fDef.mapKeyType = null;
            this.fDef.mapValueType = null;
        }
        this.flagValue = null;
        this.flagType = null;
        this.listOfAnnotations = null;
        this.debug("field name" + token3.image + " type=" + this.fDef.type);
    }

    public final void FieldFlag() throws ParseException {
        this.jj_consume_token(71);
        this.jj_consume_token(53);
        this.flagType = this.token.image;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                this.jj_consume_token(44);
                this.flagValue = this.token.image;
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
    }

    public final String VariableInitializer(ArrayList arrayList) throws ParseException {
        String string = null;
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                string = this.ArrayInitializer(new ArrayList());
                break;
            }
            case 33: 
            case 41: 
            case 44: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 63: {
                token = this.Literal();
                string = token.image;
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (arrayList != null && string != null) {
            arrayList.add(string);
        }
        return string;
    }

    public final String ArrayInitializer(ArrayList arrayList) throws ParseException {
        this.jj_consume_token(58);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: 
            case 41: 
            case 44: 
            case 48: 
            case 50: 
            case 51: 
            case 53: 
            case 58: 
            case 63: {
                this.VariableInitializer(arrayList);
                while (this.jj_2_1(2)) {
                    this.jj_consume_token(62);
                    this.VariableInitializer(arrayList);
                }
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        this.jj_consume_token(59);
        String string = arrayList.get(0).toString();
        if (arrayList.size() > 1) {
            string = "{" + string;
            for (int i = 1; i < arrayList.size(); ++i) {
                string = string + "," + arrayList.get(i);
            }
            string = string + "}";
        }
        return string;
    }

    public final Token Literal() throws ParseException {
        Token token;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                token = this.jj_consume_token(44);
                break;
            }
            case 48: {
                token = this.jj_consume_token(48);
                break;
            }
            case 50: {
                token = this.jj_consume_token(50);
                break;
            }
            case 51: {
                token = this.jj_consume_token(51);
                break;
            }
            case 33: 
            case 41: {
                token = this.BooleanLiteral();
                break;
            }
            case 53: 
            case 63: {
                token = this.EnumConstant(false);
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.debug("Initialised literal =" + token.image);
        return token;
    }

    public final Token BooleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            default: {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token;
    }

    public final Token Type() throws ParseException {
        Token token;
        this.primitive = false;
        this.list = false;
        this.map = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                token = this.ClassType();
                break;
            }
            case 23: 
            case 24: {
                token = this.ListType();
                this.list = true;
                break;
            }
            case 22: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                token = this.PrimitiveType();
                this.primitive = true;
                break;
            }
            case 25: {
                token = this.MapType();
                this.map = true;
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    public final Token ClassType() throws ParseException {
        this.jj_consume_token(53);
        return this.token;
    }

    public final Token MapType() throws ParseException {
        Token token = null;
        token = this.jj_consume_token(25);
        return token;
    }

    public final Token ListType() throws ParseException {
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                token = this.jj_consume_token(23);
                break;
            }
            case 24: {
                token = this.jj_consume_token(24);
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return token;
    }

    public final Token TypeArguments() throws ParseException {
        Token token = null;
        this.jj_consume_token(69);
        token = this.Type();
        this.jj_consume_token(70);
        return token;
    }

    public final ArrayList<Token> MapArguments() throws ParseException {
        Token token = null;
        Token token2 = null;
        this.jj_consume_token(69);
        token = this.Type();
        this.jj_consume_token(62);
        token2 = this.Type();
        this.jj_consume_token(70);
        ArrayList<Token> arrayList = new ArrayList<Token>();
        arrayList.add(token);
        arrayList.add(token2);
        return arrayList;
    }

    public final Token PrimitiveType() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                break;
            }
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            case 26: {
                this.jj_consume_token(26);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token;
    }

    public final void Annotation() throws ParseException {
        this.annotation = null;
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            this.NormalAnnotation();
        } else if (this.jj_2_3(Integer.MAX_VALUE)) {
            this.SingleMemberAnnotation();
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 63: {
                    this.MarkerAnnotation();
                    break;
                }
                default: {
                    this.jj_la1[50] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final void NormalAnnotation() throws ParseException {
        this.jj_consume_token(63);
        this.AnnotationName();
        this.jj_consume_token(56);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                this.MemberValuePairs();
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
            }
        }
        this.jj_consume_token(57);
    }

    public final void MarkerAnnotation() throws ParseException {
        this.jj_consume_token(63);
        this.AnnotationName();
    }

    public final void SingleMemberAnnotation() throws ParseException {
        this.jj_consume_token(63);
        this.AnnotationName();
        this.jj_consume_token(56);
        this.MemberValuePairs();
        this.jj_consume_token(57);
    }

    public final void AnnotationName() throws ParseException {
        Token token = null;
        token = this.Name();
        if (annotNsp == null) {
            throw new ParseException(this.token.image + " at line(" + this.token.beginLine + "," + this.token.beginColumn + ") threw exception because annotations are not loaded");
        }
        if (annotNsp.findClassDef(token.image) == null) {
            throw new ParseException(this.token.image + " at line(" + this.token.beginLine + "," + this.token.beginColumn + ") is not a valid Annotation. Only supported annotations are" + annotNsp.getClasses());
        }
        this.annotation = new AnnotationDefValues(annotNsp.findClassDef(this.token.image));
        if (this.listOfAnnotations == null) {
            this.listOfAnnotations = new ArrayList<AnnotationDefValues>();
        }
        this.listOfAnnotations.add(this.annotation);
    }

    public final void MemberValuePairs() throws ParseException {
        this.MemberValuePair();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 62: {
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(62);
            this.MemberValuePair();
        }
    }

    public final void MemberValuePair() throws ParseException {
        Token token = null;
        Object object = null;
        token = this.jj_consume_token(53);
        this.jj_consume_token(67);
        object = this.MemberValue();
        ClassDef classDef = this.annotation.getAnnotationDef();
        FieldDef fieldDef = classDef.findField(token.image);
        if (fieldDef == null) {
            throw new ParseException("'" + token.image + "' at line(" + token.beginLine + "," + token.beginColumn + ") is not a valid attribute of annotation '" + classDef.getName() + "' . Only supported attributes are" + classDef.getFields());
        }
        this.annotation.getAnnotationFieldValues().add(new AnnotationDefValues.AnnotationValue(fieldDef, (String)object));
    }

    public final Object MemberValue() throws ParseException {
        Object var1_1 = null;
        Token token = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                this.Annotation();
                break;
            }
            case 58: {
                this.MemberValueArrayInitializer();
                break;
            }
            case 33: 
            case 41: 
            case 44: 
            case 48: 
            case 50: 
            case 51: 
            case 53: {
                token = this.Literal();
                return token.image;
            }
            default: {
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final void MemberValueArrayInitializer() throws ParseException {
        this.jj_consume_token(58);
        this.MemberValue();
        while (this.jj_2_4(2)) {
            this.jj_consume_token(62);
            this.MemberValue();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 62: {
                this.jj_consume_token(62);
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
            }
        }
        this.jj_consume_token(59);
    }

    public final Token Name() throws ParseException {
        Token token = this.jj_consume_token(53);
        return token;
    }

    String getComment() throws ParseException {
        Token token = this.token;
        if (token.specialToken == null && (token = token.next) == null) {
            return null;
        }
        if (token.specialToken == null) {
            return null;
        }
        Token token2 = token.specialToken;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        String string = "";
        while (token2 != null) {
            if (token2.image != null) {
                string = string + token2.image.replaceAll("//", " *").replaceAll("\n", "\\\n\t");
            }
            token2 = token2.next;
        }
        return string;
    }

    public final void debug(String string) throws ParseException {
    }

    String getFunctionContent() throws ParseException {
        Token token = this.token;
        if (token.specialToken == null && (token = token.next) == null) {
            return null;
        }
        if (token.specialToken == null) {
            return null;
        }
        Token token2 = token.specialToken;
        while (token2.specialToken != null) {
            token2 = token2.specialToken;
        }
        String string = "";
        while (token2 != null) {
            if (token2.image != null) {
                string = string + token2.image;
            }
            token2 = token2.next;
        }
        string = string.replace("/.", " ");
        string = string.replace("./", " ");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int n) {
        this.jj_la = n;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess lookaheadSuccess) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, n);
        }
    }

    private boolean jj_3_1() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3R_36() {
        return this.jj_3R_41();
    }

    private boolean jj_3R_32() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_36()) {
            this.jj_scanpos = token;
            if (this.jj_3R_37()) {
                this.jj_scanpos = token;
                if (this.jj_3R_38()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_35() {
        return this.jj_3R_40();
    }

    private boolean jj_3R_26() {
        return this.jj_scan_token(53);
    }

    private boolean jj_3R_34() {
        return this.jj_3R_39();
    }

    private boolean jj_3R_20() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_24()) {
            this.jj_scanpos = token;
            if (this.jj_3R_25()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_22() {
        if (this.jj_scan_token(53)) {
            return true;
        }
        return this.jj_scan_token(67);
    }

    private boolean jj_3R_33() {
        return this.jj_scan_token(58);
    }

    private boolean jj_3R_31() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(44)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(48)) {
                this.jj_scanpos = token;
                if (this.jj_scan_token(50)) {
                    this.jj_scanpos = token;
                    if (this.jj_scan_token(51)) {
                        this.jj_scanpos = token;
                        if (this.jj_3R_34()) {
                            this.jj_scanpos = token;
                            if (this.jj_3R_35()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_21() {
        return this.jj_3R_26();
    }

    private boolean jj_3R_29() {
        return this.jj_3R_31();
    }

    private boolean jj_3R_28() {
        return this.jj_3R_33();
    }

    private boolean jj_3R_42() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_23() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = token;
            if (this.jj_3R_28()) {
                this.jj_scanpos = token;
                if (this.jj_3R_29()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_27() {
        return this.jj_3R_32();
    }

    private boolean jj_3R_43() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_44() {
        return this.jj_3R_32();
    }

    private boolean jj_3R_30() {
        return this.jj_scan_token(58);
    }

    private boolean jj_3_3() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_3R_21()) {
            return true;
        }
        return this.jj_scan_token(56);
    }

    private boolean jj_3R_41() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_40() {
        Token token = this.jj_scanpos;
        if (this.jj_3R_44()) {
            this.jj_scanpos = token;
        }
        return this.jj_scan_token(53);
    }

    private boolean jj_3_2() {
        if (this.jj_scan_token(63)) {
            return true;
        }
        if (this.jj_3R_21()) {
            return true;
        }
        if (this.jj_scan_token(56)) {
            return true;
        }
        Token token = this.jj_scanpos;
        if (this.jj_3R_22()) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(57)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(62)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private boolean jj_3R_38() {
        return this.jj_3R_43();
    }

    private boolean jj_3R_25() {
        return this.jj_3R_31();
    }

    private boolean jj_3R_39() {
        Token token = this.jj_scanpos;
        if (this.jj_scan_token(41)) {
            this.jj_scanpos = token;
            if (this.jj_scan_token(33)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_37() {
        return this.jj_3R_42();
    }

    private boolean jj_3R_24() {
        return this.jj_3R_30();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0, 0, 688128, 0, 0, 0, -1341489152, 0, 0, 0x200000, 0, 0, 0, -1878360064, -1341489152, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 688128, 0x150000, 688128, 0x150000, 688128, 0x150000, 1338671104, 1338671104, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1337982976, 0x1800000, 0x4C400000, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{8, 16, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 1024, Integer.MIN_VALUE, 2048, 0, 0x200000, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0x40000000, 0x40000000, 0, 0, 4096, 0, 1, 0x40000000, 0x40000000, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0x40000000, 0, 0, 0, 0, 0, 0, -2145386012, -2145386012, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0, -2077421054, -2077421054, 0x40000000, -2144529918, 514, 2097636, 0, 484, Integer.MIN_VALUE, 0x200000, 0x40000000, -2077421054, 0x40000000};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 2, 0, 0, 0, 0, 0, 0, 8, 16, 0, 32, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 128, 128, 0, 0, 128, 1, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public MessageParser(InputStream inputStream) {
        this(inputStream, null);
    }

    public MessageParser(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream = new JavaCharStream(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source = new MessageParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 55; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(InputStream inputStream) {
        this.ReInit(inputStream, null);
    }

    public void ReInit(InputStream inputStream, String string) {
        int n;
        try {
            this.jj_input_stream.ReInit(inputStream, string, 1, 1);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 55; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public MessageParser(Reader reader) {
        int n;
        this.jj_input_stream = new JavaCharStream(reader, 1, 1);
        this.token_source = new MessageParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 55; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(Reader reader) {
        int n;
        this.jj_input_stream.ReInit(reader, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 55; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public MessageParser(MessageParserTokenManager messageParserTokenManager) {
        int n;
        this.token_source = messageParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 55; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    public void ReInit(MessageParserTokenManager messageParserTokenManager) {
        int n;
        this.token_source = messageParserTokenManager;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (n = 0; n < 55; ++n) {
            this.jj_la1[n] = -1;
        }
        for (n = 0; n < this.jj_2_rtns.length; ++n) {
            this.jj_2_rtns[n] = new JJCalls();
        }
    }

    private Token jj_consume_token(int n) throws ParseException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == n) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls jJCalls = this.jj_2_rtns[i];
                    while (jJCalls != null) {
                        if (jJCalls.gen < this.jj_gen) {
                            jJCalls.first = null;
                        }
                        jJCalls = jJCalls.next;
                    }
                }
            }
            return this.token;
        }
        this.token = token;
        this.jj_kind = n;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int n) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int n2 = 0;
            Token token = this.token;
            while (token != null && token != this.jj_scanpos) {
                ++n2;
                token = token.next;
            }
            if (token != null) {
                this.jj_add_error_token(n, n2);
            }
        }
        if (this.jj_scanpos.kind != n) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int n) {
        Token token = this.token;
        for (int i = 0; i < n; ++i) {
            token = token.next != null ? token.next : (token.next = this.token_source.getNextToken());
        }
        return token;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int n, int n2) {
        if (n2 >= 100) {
            return;
        }
        if (n2 == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = n;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] nArray : this.jj_expentries) {
                if (nArray.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (nArray[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (n2 != 0) {
                this.jj_endpos = n2;
                this.jj_lasttokens[this.jj_endpos - 1] = n;
            }
        }
    }

    public ParseException generateParseException() {
        int n;
        int n2;
        this.jj_expentries.clear();
        boolean[] blArray = new boolean[72];
        if (this.jj_kind >= 0) {
            blArray[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (n2 = 0; n2 < 55; ++n2) {
            if (this.jj_la1[n2] != this.jj_gen) continue;
            for (n = 0; n < 32; ++n) {
                if ((jj_la1_0[n2] & 1 << n) != 0) {
                    blArray[n] = true;
                }
                if ((jj_la1_1[n2] & 1 << n) != 0) {
                    blArray[32 + n] = true;
                }
                if ((jj_la1_2[n2] & 1 << n) == 0) continue;
                blArray[64 + n] = true;
            }
        }
        for (n2 = 0; n2 < 72; ++n2) {
            if (!blArray[n2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = n2;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] nArrayArray = new int[this.jj_expentries.size()][];
        for (n = 0; n < this.jj_expentries.size(); ++n) {
            nArrayArray[n] = (int[])this.jj_expentries.get(n);
        }
        return new ParseException(this.token, nArrayArray, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 4; ++i) {
            try {
                JJCalls jJCalls = this.jj_2_rtns[i];
                do {
                    if (jJCalls.gen <= this.jj_gen) continue;
                    this.jj_la = jJCalls.arg;
                    this.jj_lastpos = this.jj_scanpos = jJCalls.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                        }
                    }
                } while ((jJCalls = jJCalls.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int n, int n2) {
        JJCalls jJCalls = this.jj_2_rtns[n];
        while (jJCalls.gen > this.jj_gen) {
            if (jJCalls.next == null) {
                jJCalls = jJCalls.next = new JJCalls();
                break;
            }
            jJCalls = jJCalls.next;
        }
        jJCalls.gen = this.jj_gen + n2 - this.jj_la;
        jJCalls.first = this.token;
        jJCalls.arg = n2;
    }

    static {
        String string = System.getProperty("os.name");
        if (string != null && !string.startsWith("Win")) {
            unix = true;
        }
        nsMap = new HashMap();
        annotationPath = null;
        langType = "java";
        MessageParser.jj_la1_init_0();
        MessageParser.jj_la1_init_1();
        MessageParser.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

