/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.generator;

import commvault.tools.generator.AnnotationDefValues;
import commvault.tools.generator.ClassDef;
import commvault.tools.generator.ConstantDef;
import commvault.tools.generator.FieldDef;
import commvault.tools.generator.MessageParser;
import commvault.tools.generator.NameSpace;
import commvault.tools.generator.SubSystems;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeanModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Generator {
    private static final String XML_MESSAGES_TEMPLATE = "XmlMessagesTemplate";
    private static final String XML_ANNOTTAION_MESSAGE_GEN_LOC_JAVA = "XmlAnnotationMessageGenLocJava";
    private static final String XMLMANAGED_MSG_SRC = "XMLManagedMsgSrc";
    private static final String XML_MESSAGE_INCLUDE = "XmlMessageInclude";
    private static final String XMLMESSAGE_SRC = "XMLMessageSrc";
    private static final String XMLMESSAGES = "XMLMessages";
    private static final String XMLMESSAGES_EX = "XMLMsgEx";
    private static final String XMLMESSAGESUBSYS = "XMLMessageSubSys";
    private static final String MSG_COUNT_PER_FILE = "MessageCountPerFile";
    private static final String GENERATE_XPATH_SEPARATE = "GenerateXPathSeparate";
    private static final String USE_BINARY_TEMPLATE = "UseBinaryTemplate";
    private static final String XMLMESSAGEXPATHKEYS = "XPathKeysLoc";
    private static final String XMLMESSAGE_TASKOPTIONS_GENLOC = "TaskOptionsGenLoc";
    private static final String XMLMESSAGE_APPGROUP_GENLOC = "AppGroupsGenLoc";
    private static final String XMLMESSAGE_APPGROUP_SRC_GENLOC = "AppGroupsSrcGenLoc";
    private static final String XMLMESSAGE_DBSCRIPT_GENLOC = "DBScriptGenLoc";
    private static final String EXPORT_DLLNAME = "EXPORT_DLLNAME";
    private static final String XML_UNIFIED_TAB_NAME = "Unified";
    private static final String XML_ALL_SUBSYSTEMS = "AllSubsystems";
    static Properties config = new Properties();
    private static String VAULTCX_SOURCE_COMMON_XML_MESSAGE;
    private static String VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC;
    private static String VAULTCX_SOURCE_INCLUDE_XML_MESSAGE;
    private static String VAULTCX_SOURCE_COMMON_XMLMESSAGE_CS_SRC;
    private static String VAULTCX_SOURCE_MESSAGE_SUBSYSTEM;
    private static int MAX_MESSAGE_IN_FILE;
    private static int IS_GENERATE_XPATH_SEPARATE;
    private static String VAULTCX_SOURCE_COMMON_XML_MESSAGE_EX;
    private static String VAULTCX_SOURCE_MESSAGE_XPATHKEYS;
    private static String VAULTCX_SOURCE_MESSAGE_TASKOPTIONS_GENLOC;
    private static String VAULTCX_SOURCE_MESSAGE_APPGROUP_GENLOC;
    private static String VAULTCX_SOURCE_MESSAGE_APPGROUP_SRC_GENLOC;
    private static String VAULTCX_SOURCE_MESSAGE_DBSCRIPT_GENLOC;
    private static boolean isGenerationForBinary;
    private static String root;
    private static Type sourceType;
    private static String buildType;
    private static String appGroup;
    private static OSType osType;
    public static String usePath;
    private Map<String, NameSpace> unifiedTabNamespaces = new HashMap<String, NameSpace>();
    private List<NameSpace.KeyValue> unifiedTabFileEntries = new ArrayList<NameSpace.KeyValue>();

    public List<NameSpace.KeyValue> getUnifiedKeyValues() {
        return this.unifiedTabFileEntries;
    }

    private Configuration createConfiguration(String string) {
        System.out.println("processing template:" + string);
        Configuration configuration = new Configuration();
        BeansWrapper beansWrapper = new BeansWrapper(){

            public TemplateModel wrap(Object object) throws TemplateModelException {
                if (object == null) {
                    return super.wrap((Object)"null");
                }
                if (object instanceof Integer || object instanceof Boolean || object instanceof String || object instanceof Collection || object.getClass().isPrimitive() || object instanceof Map) {
                    return super.wrap(object);
                }
                return new BeanModel(object, (BeansWrapper)this);
            }
        };
        beansWrapper.setExposeFields(true);
        beansWrapper.setMethodsShadowItems(true);
        configuration.setObjectWrapper((ObjectWrapper)beansWrapper);
        try {
            configuration.setTemplateLoader((TemplateLoader)new FileTemplateLoader(new File(string)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(-1);
        }
        return configuration;
    }

    public void generateJava(Configuration configuration, String string, String string2) throws Exception {
        String string3;
        Template template;
        String string4;
        String string5 = string + config.getProperty(XMLMESSAGE_SRC) + string2 + "/";
        if (string2.startsWith("Annotation")) {
            string5 = string + config.getProperty(XML_ANNOTTAION_MESSAGE_GEN_LOC_JAVA) + "/";
        }
        String string6 = string + VAULTCX_SOURCE_COMMON_XML_MESSAGE + string2 + ".x";
        new File(string6).lastModified();
        NameSpace nameSpace = MessageParser.parse(string6, Integer.parseInt(SubSystems.getIdMap().get(string2).toString()));
        boolean bl = true;
        for (ClassDef object : nameSpace.getAllClasses()) {
            string4 = object.getSimpleName();
            template = configuration.getTemplate("java/class.template");
            if (object.enumType) {
                template = configuration.getTemplate("java/enum.template");
            } else if (string2.startsWith("Annotation")) {
                template = configuration.getTemplate("java/Annotation.template");
            }
            string3 = string5 + string4 + ".java";
            this.generateJava(template, nameSpace, object, string3);
        }
        if (!bl) {
            System.out.println("Not generating anything for file:" + string6);
        }
        for (ConstantDef constantDef : nameSpace.getConstants()) {
            string4 = constantDef.getName();
            template = configuration.getTemplate("java/constant.template");
            string3 = string5 + string4 + ".java";
            this.generateJava(template, nameSpace, constantDef, string3);
        }
        if (isGenerationForBinary) {
            this.generateBinarySubSystemReference(configuration, nameSpace, string5);
        }
    }

    private void generateBinarySubSystemReference(Configuration configuration, NameSpace nameSpace, String string) throws Exception {
        HashMap<String, NameSpace> hashMap = new HashMap<String, NameSpace>();
        hashMap.put("package", nameSpace);
        Template template = configuration.getTemplate("java/subsystem.template");
        String string2 = string + nameSpace.name + "SubSystemReferenceClass.java";
        File file = new File(string2);
        Generator.createFile(file, false);
        Generator.process(template, hashMap, file);
    }

    private void generateJava(Template template, NameSpace nameSpace, Object object, String string) throws IOException, TemplateException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("clazz", object);
        hashMap.put("namespace", nameSpace.name);
        hashMap.put("includes", nameSpace.getIncludes());
        hashMap.put("functionContent", nameSpace.getFunctionContent());
        File file = new File(string);
        Generator.createFile(file, false);
        Generator.process(template, hashMap, file);
    }

    public static void createFile(File file, boolean bl) throws IOException {
        try {
            if (file.exists()) {
                return;
            }
            Generator.createFile(file.getParentFile(), true);
            if (bl) {
                file.mkdir();
            } else {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            System.out.println("failed creating:" + file);
            throw iOException;
        }
        catch (Exception exception) {
            System.out.println("failed creating:" + file);
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void generatePI(NameSpace nameSpace, String string) {
        try {
            NameSpace nameSpace2 = MessageParser.parse(string + VAULTCX_SOURCE_COMMON_XML_MESSAGE + "CvEntities.x", 18);
            List<ClassDef> list = nameSpace.getClasses();
            ArrayList<ClassDef> arrayList = new ArrayList<ClassDef>();
            if (nameSpace2 != null) {
                for (ClassDef classDef : nameSpace2.getClasses()) {
                    for (AnnotationDefValues iterator : classDef.getAnnotations()) {
                        if (!iterator.getAnnotationDef().name.equals("ProcessingInstruction")) continue;
                        arrayList.add(classDef);
                    }
                }
            }
            if (arrayList != null) {
                for (ClassDef classDef : list) {
                    if (classDef.isEnumType() || classDef.isSingleInheritance()) continue;
                    boolean bl = true;
                    for (AnnotationDefValues annotationDefValues : classDef.getAnnotations()) {
                        if (!annotationDefValues.getAnnotationDef().name.equals("NoProcessingInstruction")) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    for (ClassDef classDef2 : arrayList) {
                        FieldDef fieldDef = new FieldDef();
                        fieldDef.name = classDef2.name.toLowerCase();
                        fieldDef.type = ClassDef.create(classDef2.name, nameSpace2);
                        fieldDef.templateType = null;
                        fieldDef.index = classDef2.getFieldCounts();
                        fieldDef.setRef(true);
                        classDef.getFields().add(0, fieldDef);
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Exception while generating PI." + exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public boolean IsCommonSubsystem(String string) {
        return string.compareToIgnoreCase("Annotation") == 0 || string.compareToIgnoreCase("CvEntities") == 0 || string.compareToIgnoreCase("Common") == 0 || string.compareToIgnoreCase("CNSession") == 0 || string.compareToIgnoreCase("CNRegistration") == 0;
    }

    public void generateHeader(Configuration configuration, NameSpace nameSpace, String string, String string2, boolean bl, boolean bl2) throws IOException, TemplateException {
        File file = null;
        if (!this.IsCommonSubsystem(string2)) {
            file = new File(string + VAULTCX_SOURCE_INCLUDE_XML_MESSAGE + string2 + "Base.h");
            this.processTemplate("cpp/subsystemheader.template", configuration, nameSpace, bl, bl2, file);
            file = new File(string + VAULTCX_SOURCE_INCLUDE_XML_MESSAGE + string2 + "EnumBase.h");
            this.processTemplate("cpp/enumheader.template", configuration, nameSpace, bl, bl2, file);
            file = new File(string + VAULTCX_SOURCE_INCLUDE_XML_MESSAGE + string2 + "EnumClassBase.h");
            this.processTemplate("cpp/enumclassheader.template", configuration, nameSpace, bl, bl2, file);
            for (ClassDef classDef : nameSpace.getAllClasses()) {
                if (classDef.enumType) continue;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("clazz", classDef);
                hashMap.put("namespace", nameSpace);
                hashMap.put("functionContent", nameSpace.getFunctionContent());
                file = new File(string + VAULTCX_SOURCE_INCLUDE_XML_MESSAGE + string2 + classDef.name + "Msg.h");
                this.processTemplate("cpp/classheader.template", configuration, hashMap, bl, bl2, file);
            }
        } else {
            file = new File(string + VAULTCX_SOURCE_INCLUDE_XML_MESSAGE + string2 + "Msgs.h");
            this.processTemplate("cpp/classheaderall.template", configuration, nameSpace, bl, bl2, file);
        }
        if (osType != OSType.WIN) {
            file = new File(string + VAULTCX_SOURCE_INCLUDE_XML_MESSAGE + string2 + "Includes.h");
            this.processTemplate("cpp/includes.template", configuration, nameSpace, bl, bl2, file);
        }
    }

    public void generateCPP(Configuration configuration, String string, String string2, boolean bl, boolean bl2) throws Exception {
        int n;
        File file;
        File file2;
        File file3 = new File(string2 + VAULTCX_SOURCE_COMMON_XML_MESSAGE + string + ".x");
        long l = file3.lastModified();
        NameSpace nameSpace = null;
        String string3 = string;
        if (string.indexOf(47) >= 0) {
            string3 = string.substring(string.indexOf(47) + 1);
        }
        if (!(file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3 + "/" + string3 + "Msgs_2.cpp")).canRead()) {
            System.out.println("Cannot find file: " + file2.getAbsolutePath());
        }
        if (osType == OSType.WIN && (file = new File(string2 + VAULTCX_SOURCE_COMMON_XML_MESSAGE + "/Client/" + string + ".x")).exists()) {
            System.out.println("Client file: " + file.getAbsolutePath());
            long l2 = file.lastModified();
            if (l2 > l) {
                l = l2;
                System.out.println("Client File modified time is recent. Hence regenerating files");
            }
        }
        long l3 = file2.lastModified();
        boolean bl3 = false;
        String[] stringArray = new String[]{"classheader.template", "classheaderall.template", "cppimp.template", "cppimp_2.template", "cppimp_xpath.template", "enumclassheader.template", "enumheader.template", "subsystemheader.template"};
        Object object = stringArray;
        int n2 = ((String[])object).length;
        for (n = 0; n < n2; ++n) {
            String string4 = object[n];
            File file4 = new File(string2 + VAULTCX_SOURCE_COMMON_XML_MESSAGE + "templates/cpp/" + string4);
            long l4 = file4.lastModified();
            boolean bl4 = bl3 = l4 > l3;
            if (bl3) {
                System.out.println("Template file got changed " + file4.getPath());
                break;
            }
            file4 = new File(string2 + VAULTCX_SOURCE_COMMON_XML_MESSAGE_EX + "templates/cpp/" + string4);
            l4 = file4.lastModified();
            boolean bl5 = bl3 = l4 > l3;
            if (!bl3) continue;
            System.out.println("Template file got changed " + file4.getPath());
            break;
        }
        boolean bl6 = bl2 = bl2 & l > l3 || bl2 & bl || bl3;
        if (bl3) {
            System.out.println(string3 + " Template has changed hence generating the files!");
        }
        if (bl2) {
            MessageParser.annotationPath = usePath;
            nameSpace = MessageParser.parse(file3.getAbsolutePath(), Integer.parseInt(SubSystems.getIdMap().get(string).toString()));
            nameSpace.setPackageName(string3);
            if (!string.equalsIgnoreCase("Annotation") && !string.equalsIgnoreCase("CvEntities")) {
                this.generatePI(nameSpace, string2);
            }
        } else {
            System.out.println(string3 + ".x has not changed, so not generating any files!!!");
            return;
        }
        nameSpace.setCppSubsystemExternalize(nameSpace.isCPPSubSystemExternalise());
        if (bl2) {
            this.generateHeader(configuration, nameSpace, string2, string3, bl, bl2);
        }
        if (!((File)(object = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3))).exists()) {
            ((File)object).mkdir();
        } else if (((File)object).isDirectory()) {
            File[] fileArray;
            for (File file5 : fileArray = ((File)object).listFiles()) {
                System.out.println("Deleting: " + file5.getAbsolutePath());
                file5.delete();
            }
        }
        if (osType == OSType.WIN) {
            file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3 + "/" + string3 + "Msgs_1.cpp");
            nameSpace.setGenMode("NOCHECK");
            nameSpace.setGenCode("ALL");
            this.processTemplate("cpp/cppimp_2.template", configuration, nameSpace, bl, bl2, file2);
        } else {
            nameSpace.setGenMode("CHECK");
            nameSpace.setGenCode("ALL");
            nameSpace.setGenerateXPathSeparate(IS_GENERATE_XPATH_SEPARATE == 1);
            n2 = 200;
            List<ClassDef> list = nameSpace.getClasses();
            System.out.println("Total class size:" + list.size());
            for (int i = 0; i < list.size() / n2 + 1; ++i) {
                nameSpace.setClasses(this.createList(i * n2, (i + 1) * n2 - 1, list));
                System.out.println("Total size:" + nameSpace.getClasses().size());
                file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3 + "/" + string3 + "Msgs_1_" + (i + 1) + ".cpp");
                this.processTemplate("cpp/cppimp_2.template", configuration, nameSpace, bl, bl2, file2);
            }
            nameSpace.setClasses(list);
            if (nameSpace.isGenerateXPathSeparate()) {
                file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3 + "/" + string3 + "Msgs_XPATH.cpp");
                this.processTemplate("cpp/cppimp_xpath.template", configuration, nameSpace, bl, bl2, file2);
            }
            nameSpace.setGenCode("CO");
            file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3 + "/" + string3 + "Msgs_co.cpp");
            this.processTemplate("cpp/cppimp_2.template", configuration, nameSpace, bl, bl2, file2);
            nameSpace.setGenCode("SUBSYS");
            file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3 + "/" + string3 + "Msgs_subsys.cpp");
            this.processTemplate("cpp/cppimp_2.template", configuration, nameSpace, bl, bl2, file2);
            nameSpace.setGenCode("GCD");
            file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3 + "/" + string3 + "Msgs_gcd.cpp");
            this.processTemplate("cpp/cppimp_2.template", configuration, nameSpace, bl, bl2, file2);
            nameSpace.setGenCode("IIL");
            file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3 + "/" + string3 + "Msgs_iil.cpp");
            this.processTemplate("cpp/cppimp_2.template", configuration, nameSpace, bl, bl2, file2);
            nameSpace.setGenCode("GHTLM");
            file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3 + "/" + string3 + "Msgs_ghtlm.cpp");
            this.processTemplate("cpp/cppimp_2.template", configuration, nameSpace, bl, bl2, file2);
            nameSpace.setGenCode("RFL");
            file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3 + "/" + string3 + "Msgs_rfl.cpp");
            this.processTemplate("cpp/cppimp_2.template", configuration, nameSpace, bl, bl2, file2);
            nameSpace.setGenCode("GES");
            file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3 + "/" + string3 + "Msgs_ges.cpp");
            this.processTemplate("cpp/cppimp_2.template", configuration, nameSpace, bl, bl2, file2);
            nameSpace.setGenCode("ANT");
            file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3 + "/" + string3 + "Msgs_ant.cpp");
            this.processTemplate("cpp/cppimp_2.template", configuration, nameSpace, bl, bl2, file2);
        }
        List<ClassDef> list = nameSpace.getClasses();
        for (n = 0; n < list.size() / MAX_MESSAGE_IN_FILE + 1; ++n) {
            nameSpace.setClasses(this.createList(n * MAX_MESSAGE_IN_FILE, (n + 1) * MAX_MESSAGE_IN_FILE - 1, list));
            file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string3 + "/" + string3 + "Msgs_" + (n + 2) + ".cpp");
            this.processTemplate("cpp/cppimp.template", configuration, nameSpace, bl, bl2, file2);
        }
        nameSpace.setClasses(list);
    }

    public void generateCppSubsystem(Configuration configuration, String string, String string2, boolean bl, boolean bl2) throws Exception {
        File file;
        long l;
        File file2 = new File(string2 + VAULTCX_SOURCE_COMMON_XML_MESSAGE + string + ".x");
        NameSpace nameSpace = null;
        long l2 = file2.lastModified();
        boolean bl3 = bl2 = bl2 & l2 > (l = (file = new File(string2 + VAULTCX_SOURCE_INCLUDE_XML_MESSAGE + string + "Subsystem.h")).lastModified()) || bl2 & bl;
        if (!bl2) {
            return;
        }
        nameSpace = MessageParser.parse(file2.getAbsolutePath(), Integer.parseInt(SubSystems.getIdMap().get(string).toString()));
        this.processTemplate("cpp/classheader.template", configuration, nameSpace, bl, bl2, file);
        File file3 = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string);
        if (!file3.exists()) {
            file3.mkdir();
        }
        file = new File(string2 + VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC + string + "/" + string + "Subsystem.cpp");
        this.processTemplate("cpp/cppimp.template", configuration, nameSpace, bl, bl2, file);
    }

    private List<ClassDef> createList(int n, int n2, List<ClassDef> list) {
        ArrayList<ClassDef> arrayList = new ArrayList<ClassDef>();
        while (n <= n2 && n < list.size()) {
            arrayList.add(list.get(n));
            ++n;
        }
        return arrayList;
    }

    private void processTemplate(String string, Configuration configuration, NameSpace nameSpace, boolean bl, boolean bl2, File file) throws IOException, TemplateException {
        if (bl && file.exists()) {
            file.delete();
            System.out.println("deleted file://" + file.getAbsolutePath());
        }
        if (bl2) {
            Template template = configuration.getTemplate(string);
            Generator.createFile(file, false);
            Generator.process(template, (Object)nameSpace, file);
            System.out.println("generated file://" + file.getAbsolutePath());
        }
    }

    private void processTemplate(String string, Configuration configuration, HashMap<String, Object> hashMap, boolean bl, boolean bl2, File file) throws IOException, TemplateException {
        if (bl && file.exists()) {
            file.delete();
            System.out.println("deleted file://" + file.getAbsolutePath());
        }
        if (bl2) {
            Template template = configuration.getTemplate(string);
            Generator.createFile(file, false);
            Generator.process(template, hashMap, file);
            System.out.println("generated file://" + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFile(File file, File file2) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[4096];
            int n = 0;
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    public void generateAppGroups(Configuration configuration, String string, String string2) throws Exception {
        Template template = null;
        configuration.setTemplateLoader((TemplateLoader)new FileTemplateLoader(new File(string2)));
        NameSpace nameSpace = MessageParser.parse(string2 + VAULTCX_SOURCE_COMMON_XML_MESSAGE + string + ".x", Integer.parseInt(SubSystems.getIdMap().get(string).toString()));
        String string3 = string2 + VAULTCX_SOURCE_MESSAGE_TASKOPTIONS_GENLOC;
        String string4 = "TaskOptionDefs.h";
        File file = new File(string3 + string4);
        if (!file.exists()) {
            File file2 = new File(string3 + "TaskOptionDefsRef.h");
            System.out.println("Copying: from [" + file2 + "] to [" + file);
            this.copyFile(file2, file);
        }
        System.out.println("Loading xpath keys from : file://" + string3 + string4);
        NameSpace.loadXPathKeys(this.getFileContent(string3 + string4));
        template = configuration.getTemplate(VAULTCX_SOURCE_MESSAGE_TASKOPTIONS_GENLOC + "TaskOptionDefs.template");
        System.out.println("Generating : file://" + string3 + string4);
        Generator.process(template, (Object)nameSpace, string3 + string4);
        template = configuration.getTemplate(VAULTCX_SOURCE_MESSAGE_APPGROUP_GENLOC + "AppTypes.template");
        Generator.process(template, (Object)nameSpace, string2 + VAULTCX_SOURCE_MESSAGE_APPGROUP_GENLOC + "AppTypes.h");
        System.out.println("Generating : file://" + string2 + VAULTCX_SOURCE_MESSAGE_APPGROUP_GENLOC + "AppTypes.h");
        template = configuration.getTemplate(VAULTCX_SOURCE_MESSAGE_DBSCRIPT_GENLOC + "APP_AppTypeGroup.template");
        Generator.process(template, (Object)nameSpace, string2 + VAULTCX_SOURCE_MESSAGE_DBSCRIPT_GENLOC + "APP_AppTypeGroup.script");
        System.out.println("Generating : file://" + string2 + VAULTCX_SOURCE_MESSAGE_DBSCRIPT_GENLOC + "APP_AppTypeGroup.script");
        template = configuration.getTemplate(VAULTCX_SOURCE_MESSAGE_DBSCRIPT_GENLOC + "APP_AppTypeGroupAssoc.template");
        Generator.process(template, (Object)nameSpace, string2 + VAULTCX_SOURCE_MESSAGE_DBSCRIPT_GENLOC + "APP_AppTypeGroupAssoc.script");
        System.out.println("Generating : file://" + string2 + VAULTCX_SOURCE_MESSAGE_DBSCRIPT_GENLOC + "APP_AppTypeGroupAssoc.script");
        template = configuration.getTemplate(VAULTCX_SOURCE_MESSAGE_APPGROUP_GENLOC + "AppGroupDefinitions_H.template");
        Generator.process(template, (Object)nameSpace, string2 + VAULTCX_SOURCE_MESSAGE_APPGROUP_GENLOC + "AppGroupDefinitions.h");
        System.out.println("Generating : file://" + string2 + VAULTCX_SOURCE_MESSAGE_APPGROUP_GENLOC + "AppGroupDefinitions.h");
        template = configuration.getTemplate(VAULTCX_SOURCE_MESSAGE_APPGROUP_GENLOC + "AppGroupDefinitions_cpp.template");
        Generator.process(template, (Object)nameSpace, string2 + VAULTCX_SOURCE_MESSAGE_APPGROUP_SRC_GENLOC + "AppGroupDefinitions.cpp");
        System.out.println("Generating : file://" + string2 + VAULTCX_SOURCE_MESSAGE_APPGROUP_SRC_GENLOC + "AppGroupDefinitions.cpp");
        if (osType == OSType.WIN) {
            template = configuration.getTemplate("vaultcx/Source/CommServer/EvTaskMgrManaged/TaskOptionConstants.template");
            Generator.process(template, (Object)nameSpace, string2 + "/vaultcx/Source/CommServer/EvTaskMgrManaged/TaskOptionConstants.cs");
            System.out.println("Generating : file://" + string2 + "/vaultcx/Source/CommServer/EvTaskMgrManaged/TaskOptionConstants.cs");
        }
        template = configuration.getTemplate(VAULTCX_SOURCE_MESSAGE_DBSCRIPT_GENLOC + "TM_StaticTaskOption.template");
        Generator.process(template, (Object)nameSpace, string2 + VAULTCX_SOURCE_MESSAGE_DBSCRIPT_GENLOC + "TM_StaticTaskOption.script");
        System.out.println("Generating : file://" + string2 + VAULTCX_SOURCE_MESSAGE_DBSCRIPT_GENLOC + "TM_StaticTaskOption.script");
    }

    public void generateXpathKeys(Configuration configuration, String string, String string2) throws Exception {
        NameSpace nameSpace = MessageParser.parse(string2 + VAULTCX_SOURCE_COMMON_XML_MESSAGE + string + ".x", Integer.parseInt(SubSystems.getIdMap().get(string).toString()));
        if (nameSpace.getDotXPathFields().size() > 0) {
            File file;
            String string3 = string2 + VAULTCX_SOURCE_MESSAGE_XPATHKEYS + string;
            String string4 = "OptionDefs.h";
            File file2 = new File(string3 + string4);
            if (!file2.exists()) {
                file = new File(string3 + "OptionDefsRef.h");
                System.out.println("Copying: from [" + file + "] to [" + file2);
                this.copyFile(file, file2);
            }
            System.out.println("Loading Xpath keys from file://" + string3 + string4 + ".");
            NameSpace.loadXPathKeys(this.getFileContent(string3 + string4));
            configuration.setTemplateLoader((TemplateLoader)new FileTemplateLoader(new File(string2)));
            file = configuration.getTemplate(VAULTCX_SOURCE_MESSAGE_XPATHKEYS + "XPathOptionDefs.template");
            System.out.println("Generating: file://" + string2 + VAULTCX_SOURCE_MESSAGE_XPATHKEYS + string + string4);
            Generator.process((Template)file, (Object)nameSpace, string2 + VAULTCX_SOURCE_MESSAGE_XPATHKEYS + string + string4);
        }
    }

    public void generateXmlTabFiles(Configuration configuration, String string, String string2) throws Exception {
        String string3 = null;
        string3 = osType == OSType.WIN ? "vaultcx/Source/Common/EventMessage/Include/" : "/source/common/EventMessage/Include/";
        String string4 = string2 + "/" + string3 + "XML" + string + "locale.template";
        NameSpace nameSpace = MessageParser.parse(string2 + VAULTCX_SOURCE_COMMON_XML_MESSAGE + string + ".x", Integer.parseInt(SubSystems.getIdMap().get(string).toString()));
        if (!nameSpace.isCPPSubSystemExternalise()) {
            if (!this.unifiedTabNamespaces.containsKey(string)) {
                this.unifiedTabNamespaces.put(string, nameSpace);
            }
            return;
        }
        this.generateKeyValuesForTabFiles(string, nameSpace, string4);
        configuration.setTemplateLoader((TemplateLoader)new FileTemplateLoader(new File(string2)));
        Template template = configuration.getTemplate(string3 + "XmlComment.template");
        String string5 = string2 + "/" + string3 + "XML" + string + "locale.tab";
        template.process((Object)nameSpace, (Writer)new FileWriter(string5));
        System.out.println("Generating : file://" + string5 + ".");
    }

    public void generateUnifiedXmlTabFile(Configuration configuration, String string) throws Exception {
        String string2 = null;
        string2 = osType == OSType.WIN ? "vaultcx/Source/Common/EventMessage/Include/" : "/source/common/EventMessage/Include/";
        String string3 = string + "/" + string2 + "XML" + XML_UNIFIED_TAB_NAME + "locale.template";
        Map<String, String> map = this.getExistingKeys(string3);
        for (NameSpace object2 : this.unifiedTabNamespaces.values()) {
            this.generateKeyValuesForTabFileForSingleNamespace(object2.name, object2, map);
        }
        for (String string4 : map.keySet()) {
            this.unifiedTabFileEntries.add(new NameSpace.KeyValue(string4, map.get(string4)));
        }
        configuration.setTemplateLoader((TemplateLoader)new FileTemplateLoader(new File(string)));
        Iterator<Object> iterator = configuration.getTemplate(string2 + "XmlUnifiedTabTemplate.template");
        String string5 = string + "/" + string2 + "XML" + XML_UNIFIED_TAB_NAME + "locale.tab";
        iterator.process(this, new FileWriter(string5));
        System.out.println("Generating : file://" + string5 + ".");
    }

    private void generateKeyValuesForTabFileForSingleNamespace(String string, NameSpace nameSpace, Map<String, String> map) throws Exception {
        boolean bl = nameSpace.isCPPSubSystemExternalise();
        for (ClassDef classDef : nameSpace.getClasses()) {
            AnnotationDefValues.AnnotationValue annotationValue;
            String string2 = (string + "_" + classDef.getName()).toUpperCase();
            String string3 = classDef.getTextAnnotDisplayableText();
            if (string3 != null) {
                map.put(string2, string3);
            }
            if ((annotationValue = classDef.getCommentAnnot()) != null) {
                String string4 = string2 + "_COMMENT";
                map.put(string4, annotationValue.getUnquotedValue());
            }
            boolean bl2 = bl;
            for (FieldDef fieldDef : classDef.getFieldDefs()) {
                AnnotationDefValues.AnnotationValue annotationValue2;
                String string5;
                String string6 = fieldDef.getDisplayableText(bl2 = map.containsKey(string5 = (string + "_" + classDef.getName() + "_" + fieldDef.getName()).toUpperCase()));
                if (string6 != null) {
                    map.put(string5, string6);
                }
                if ((annotationValue2 = fieldDef.getCommentAnnot()) == null) continue;
                String string7 = string5 + "_COMMENT";
                map.put(string7, annotationValue2.getUnquotedValue());
            }
        }
    }

    private void generateKeyValuesForTabFiles(String string, NameSpace nameSpace, String string2) throws Exception {
        ArrayList<NameSpace.KeyValue> arrayList = new ArrayList<NameSpace.KeyValue>();
        Map<String, String> map = this.getExistingKeys(string2);
        this.generateKeyValuesForTabFileForSingleNamespace(string, nameSpace, map);
        for (String string3 : map.keySet()) {
            arrayList.add(new NameSpace.KeyValue(string3, map.get(string3)));
        }
        nameSpace.setKeyValues(arrayList);
    }

    private Map<String, String> getExistingKeys(String string) throws Exception {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        File file = new File(string);
        if (!file.exists()) {
            return linkedHashMap;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string2 = null;
        while ((string2 = bufferedReader.readLine()) != null) {
            int n;
            if (string2.startsWith("#") || string2.length() <= 0) continue;
            string2 = string2.trim();
            int n2 = string2.indexOf(32);
            int n3 = string2.indexOf(9);
            if (n2 <= 0) {
                n2 = Integer.MAX_VALUE;
            }
            if (n3 <= 0) {
                n3 = Integer.MAX_VALUE;
            }
            if ((n = Math.min(n2, n3)) == Integer.MAX_VALUE) {
                linkedHashMap.put(string2, "");
                continue;
            }
            String string3 = string2.substring(0, n);
            string2.substring(n + 1).trim();
            linkedHashMap.put(string3, "");
        }
        return linkedHashMap;
    }

    public void generate(Type type, String string, String string2, String string3) throws Exception {
        Configuration configuration = this.createConfiguration(string + config.getProperty(XML_MESSAGES_TEMPLATE));
        VAULTCX_SOURCE_MESSAGE_SUBSYSTEM = config.getProperty(XMLMESSAGESUBSYS);
        MAX_MESSAGE_IN_FILE = Integer.parseInt(config.getProperty(MSG_COUNT_PER_FILE, String.valueOf(Integer.MAX_VALUE)));
        isGenerationForBinary = Boolean.parseBoolean(config.getProperty(USE_BINARY_TEMPLATE, String.valueOf(false)));
        System.out.println("Subsystem Path being generated:" + VAULTCX_SOURCE_MESSAGE_SUBSYSTEM);
        SubSystems.load(new File(string + VAULTCX_SOURCE_MESSAGE_SUBSYSTEM));
        Map map = SubSystems.getIdMap();
        Set set = map.keySet();
        NameSpace.type = type;
        boolean bl = true;
        boolean bl2 = false;
        if (string2 != null) {
            bl2 = !string2.equals("build");
            bl = !string2.equals("clean");
        } else {
            string2 = "build";
        }
        for (String string4 : set) {
            if (string4.charAt(0) == '@') continue;
            System.out.println(string2 + "ing ..." + string4 + " for " + type.ordinal());
            switch (type) {
                case java: {
                    MessageParser.langType = "java";
                    this.generateJava(configuration, string, string4);
                    break;
                }
                case cs: {
                    MessageParser.langType = "cs";
                    if (string3 == null) {
                        System.out.println("Generating CS " + string);
                        this.generateCs(configuration, string, string4, bl2, bl);
                        break;
                    }
                    if (!string3.equalsIgnoreCase("CSLOCALE")) break;
                    System.out.println("Generating CS Locale " + string);
                    this.generateCsXMLLocale(configuration, string, string4, bl2, bl);
                    break;
                }
                case CPP: {
                    MessageParser.langType = "cpp";
                    if (string3 == null) {
                        System.out.println("Generating CPP " + string);
                        this.generateCPP(configuration, string4, string, bl2, bl);
                        break;
                    }
                    if (string4.equals(string3) || string3.equalsIgnoreCase("ALL")) {
                        System.out.println("Generating app groups");
                        this.generateAppGroups(configuration, string4, string);
                        break;
                    }
                    if (string3.equalsIgnoreCase("GENXPATH")) {
                        System.out.println("Generating OptionDef Files");
                        this.generateXpathKeys(configuration, string4, string);
                        break;
                    }
                    if (string3.equalsIgnoreCase("XMLTAB")) {
                        System.out.println("Generating Tab files ");
                        this.generateXmlTabFiles(configuration, string4, string);
                        break;
                    }
                    if (!string3.equalsIgnoreCase("SUBSYSTEM")) break;
                    System.out.println("Generating Subsystem files");
                    this.generateCppSubsystem(configuration, string4, string, bl2, bl);
                }
            }
        }
        if (type == Type.CPP && string3 != null && string3.equalsIgnoreCase("XMLTAB") && VAULTCX_SOURCE_MESSAGE_SUBSYSTEM.equals(config.getProperty(XML_ALL_SUBSYSTEMS))) {
            System.out.println("Generating Unified Tab File");
            this.generateUnifiedXmlTabFile(configuration, string);
        }
    }

    public void generateCsXMLLocale(Configuration configuration, String string, String string2, boolean bl, boolean bl2) throws Exception {
        String string3 = null;
        string3 = osType == OSType.WIN ? "/vaultcx/Source/Include/EventMessage/" : "/source/include/EventMessage/";
        File file = new File(string + VAULTCX_SOURCE_COMMON_XML_MESSAGE + string2 + ".x");
        NameSpace nameSpace = null;
        long l = file.lastModified();
        File file2 = new File(string + string3 + "XML" + string2 + "CSLocale.h");
        long l2 = file2.lastModified();
        bl2 = bl2 & l > l2 || bl2 & bl;
        nameSpace = MessageParser.parse(file.getAbsolutePath(), Integer.parseInt(SubSystems.getIdMap().get(string2).toString()));
        this.processTemplate("cs/classlocale.template", configuration, nameSpace, bl, bl2, file2);
    }

    public boolean HasTemplateChanged(String[] stringArray, String string, long l) {
        boolean bl = false;
        for (String string2 : stringArray) {
            File file = new File(string + VAULTCX_SOURCE_COMMON_XML_MESSAGE + "templates/cs/" + string2);
            long l2 = file.lastModified();
            boolean bl2 = bl = l2 > l;
            if (bl) {
                System.out.println("Template file got changed " + file.getPath());
                break;
            }
            file = new File(string + VAULTCX_SOURCE_COMMON_XML_MESSAGE_EX + "templates/cs/" + string2);
            l2 = file.lastModified();
            boolean bl3 = bl = l2 > l;
            if (!bl) continue;
            System.out.println("Template file got changed " + file.getPath());
            break;
        }
        return bl;
    }

    public void generateCs(Configuration configuration, String string, String string2, boolean bl, boolean bl2) throws Exception {
        File file = new File(string + VAULTCX_SOURCE_COMMON_XML_MESSAGE + string2 + ".x");
        NameSpace nameSpace = null;
        long l = file.lastModified();
        File file2 = new File(string + VAULTCX_SOURCE_COMMON_XMLMESSAGE_CS_SRC + string2 + "Msgs.cs");
        long l2 = file2.lastModified();
        String string3 = string2;
        String[] stringArray = new File(string + VAULTCX_SOURCE_COMMON_XML_MESSAGE + "/Client/" + string2 + ".x");
        if (stringArray.exists()) {
            System.out.println("Client file: " + stringArray.getAbsolutePath());
            long l3 = stringArray.lastModified();
            if (l3 > l) {
                l = l3;
                System.out.println("Client File modified time is recent. Hence regenerating files");
            }
        }
        stringArray = new String[]{"class.template", "classlocale.template"};
        boolean bl3 = false;
        bl3 = this.HasTemplateChanged(stringArray, string, l2);
        if (bl3) {
            System.out.println(string3 + " Template has changed hence generating the files!");
        }
        boolean bl4 = bl2 = bl2 & l > l2 || bl2 & bl || bl3;
        if (bl2) {
            nameSpace = MessageParser.parse(file.getAbsolutePath(), Integer.parseInt(SubSystems.getIdMap().get(string2).toString()));
            nameSpace.setCppSubsystemExternalize(nameSpace.isCPPSubSystemExternalise());
            String string4 = null;
            string4 = osType == null || osType == OSType.WIN ? "vaultcx/Source/Common/EventMessage/Include/" : "/source/common/EventMessage/Include/";
            String string5 = string + "/" + string4 + "XML";
            string5 = nameSpace.isCPPSubSystemExternalise() ? string5 + nameSpace.name : string5 + XML_UNIFIED_TAB_NAME;
            string5 = string5 + "locale.template";
            Map<String, String> map = this.getExistingKeys(string5);
            System.out.println("Tab reference template file : " + string5 + ", number of keys " + map.size());
            nameSpace.getTabReferenceFileEntries().addAll(map.keySet());
            this.processTemplate("cs/class.template", configuration, nameSpace, bl, bl2, file2);
        }
    }

    private String getFileContent(String string) throws Exception {
        StringWriter stringWriter = new StringWriter();
        Generator.copy(new FileReader(string), stringWriter);
        return stringWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int copy(Reader reader, Writer writer) throws IOException {
        try {
            int n = 0;
            char[] cArray = new char[4096];
            int n2 = -1;
            while ((n2 = reader.read(cArray)) != -1) {
                writer.write(cArray, 0, n2);
                n += n2;
            }
            writer.flush();
            int n3 = n;
            return n3;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(-1);
            }
            try {
                writer.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("------------------- Executing generator ------------------------------");
            System.out.println("Command line arguments :");
            new ArgumentParser(stringArray).parse();
            if (osType != null) {
                MessageParser.setOSType(osType.name());
                ClassDef.setOSType(osType.name());
            }
            config.list(System.out);
            new Generator().generate(sourceType, root, buildType, appGroup);
            System.out.println("----------------- Generator completed (SUCCESS) ----------------------------");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    public static void process(Template template, Object object, File file) throws TemplateException, IOException {
        Generator.process(template, object, file.getPath());
    }

    public static void process(Template template, Object object, String string) throws TemplateException, IOException {
        Generator.process(template, object, string, !string.endsWith(".cs"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(Template template, Object object, String string, boolean bl) throws TemplateException, IOException {
        File file = new File(string + (bl ? "" : ".temp"));
        FileWriter fileWriter = new FileWriter(file);
        try {
            template.process(object, (Writer)fileWriter);
        }
        finally {
            fileWriter.flush();
            fileWriter.close();
            if (!bl) {
                File file2 = new File(string);
                if (file2.exists()) {
                    file2.delete();
                }
                if (!file.renameTo(file2)) {
                    System.err.println("There was problem with renaming the file, so trying to generate inplace");
                    Generator.process(template, object, string, true);
                }
            }
        }
    }

    static {
        String string = "/vaultcx";
        String string2 = System.getProperty("os.name");
        if (!(string2 == null || string2.startsWith("Win") || string2.toLowerCase().contains("mac") || "true".equals(System.getProperty("webBuild")))) {
            string = "/cxunix";
        }
        config.put(XMLMESSAGES, string + "/Source/Common/XmlMessage/");
        config.put(XMLMESSAGE_SRC, string + "/vaultcx/Source/Common/XmlMessageSrc/");
        config.put(XMLMESSAGES_EX, string + "/Source/Common/XMLMsgEx/");
        config.put(XML_MESSAGE_INCLUDE, string + "/Source/Include/XmlMessage/");
        config.put(XMLMANAGED_MSG_SRC, string + "/Source/Common/XmlManagedMsgSrc/");
        config.put(XML_ANNOTTAION_MESSAGE_GEN_LOC_JAVA, "/CTEJava/Source/commvault/cte/common/xml/");
        config.put(XML_MESSAGES_TEMPLATE, string + "/Source/Common/XmlMessage/templates");
        config.put(XMLMESSAGESUBSYS, string + "/Source/Common/XmlMessage/subsystems");
        config.put(XMLMESSAGEXPATHKEYS, string + "/Source/Include/XPathSrc/");
        config.put(XMLMESSAGE_TASKOPTIONS_GENLOC, string + "/Source/Include/Shared/TaskMgr/");
        config.put(XMLMESSAGE_APPGROUP_GENLOC, string + "/Source/Include/AppMgr/");
        config.put(XMLMESSAGE_APPGROUP_SRC_GENLOC, string + "/Source/CommServer/AppMgr/");
        config.put(XMLMESSAGE_DBSCRIPT_GENLOC, string + "/Source/CommServer/Db/TblScript/");
        config.put(EXPORT_DLLNAME, "");
        config.put(USE_BINARY_TEMPLATE, String.valueOf(false));
        config.put(XML_ALL_SUBSYSTEMS, string + "/Source/Common/XmlMessage/SystemIDS.txt");
        try {
            String string3 = System.getProperties().getProperty("config");
            if (string3 == null) {
                System.out.println("Warning!!!!Config file is not found");
                string3 = "./config.properties";
            }
            config.load(new FileInputStream(string3.toString()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        config.list(System.out);
        VAULTCX_SOURCE_COMMON_XML_MESSAGE = config.getProperty(XMLMESSAGES);
        VAULTCX_SOURCE_COMMON_XMLMESSAGE_SRC = config.getProperty(XMLMESSAGE_SRC);
        VAULTCX_SOURCE_INCLUDE_XML_MESSAGE = config.getProperty(XML_MESSAGE_INCLUDE);
        VAULTCX_SOURCE_COMMON_XMLMESSAGE_CS_SRC = config.getProperty(XMLMANAGED_MSG_SRC);
        VAULTCX_SOURCE_MESSAGE_SUBSYSTEM = config.getProperty(XMLMESSAGESUBSYS);
        MAX_MESSAGE_IN_FILE = Integer.parseInt(config.getProperty(MSG_COUNT_PER_FILE, String.valueOf(Integer.MAX_VALUE)));
        IS_GENERATE_XPATH_SEPARATE = Integer.parseInt(config.getProperty(GENERATE_XPATH_SEPARATE, String.valueOf(Integer.MAX_VALUE)));
        VAULTCX_SOURCE_COMMON_XML_MESSAGE_EX = config.getProperty(XMLMESSAGES_EX);
        VAULTCX_SOURCE_MESSAGE_XPATHKEYS = config.getProperty(XMLMESSAGEXPATHKEYS);
        VAULTCX_SOURCE_MESSAGE_TASKOPTIONS_GENLOC = config.getProperty(XMLMESSAGE_TASKOPTIONS_GENLOC);
        VAULTCX_SOURCE_MESSAGE_APPGROUP_GENLOC = config.getProperty(XMLMESSAGE_APPGROUP_GENLOC);
        VAULTCX_SOURCE_MESSAGE_APPGROUP_SRC_GENLOC = config.getProperty(XMLMESSAGE_APPGROUP_SRC_GENLOC);
        VAULTCX_SOURCE_MESSAGE_DBSCRIPT_GENLOC = config.getProperty(XMLMESSAGE_DBSCRIPT_GENLOC);
        isGenerationForBinary = Boolean.parseBoolean(config.getProperty(USE_BINARY_TEMPLATE));
        root = "../../../..";
        sourceType = Type.CPP;
        buildType = null;
        appGroup = null;
        osType = null;
        usePath = null;
    }

    private static class ArgumentParser {
        private String[] args;
        private Map<String, String> argToValues = new HashMap<String, String>();

        public ArgumentParser(String[] stringArray) {
            this.args = stringArray;
        }

        public void parse() {
            System.err.println(Arrays.asList(this.args));
            this.updateMapFromArguments();
            System.err.println(this.argToValues);
            this.updateParams();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.putAll(this.argToValues);
            for (Object object : config.keySet()) {
                String string = object.toString();
                if (!hashMap.containsKey(string.toLowerCase())) continue;
                if (string.toLowerCase() == Generator.XMLMESSAGESUBSYS.toLowerCase()) {
                    root = new File(root).getAbsolutePath();
                    config.put(string, root + (String)hashMap.get(string.toLowerCase()));
                } else {
                    config.put(string, hashMap.get(string.toLowerCase()));
                }
                hashMap.remove(string.toLowerCase());
            }
            for (Object object : hashMap.keySet()) {
                config.put(object, hashMap.get(object));
            }
        }

        private void updateMapFromArguments() {
            for (int i = 0; i < this.args.length; ++i) {
                String string = this.args[i];
                System.out.println("arg: " + string);
                Pattern pattern = Pattern.compile("-(\\w+)=([^\\s=]+)");
                Matcher matcher = pattern.matcher(string);
                String string2 = "";
                String string3 = "";
                if (!matcher.find()) continue;
                string2 = matcher.group(1);
                string3 = matcher.group(2);
                this.argToValues.put(string2.toLowerCase(), string3);
            }
        }

        private void updateParams() {
            String string;
            String string2 = null;
            string2 = this.argToValues.get("root");
            if (string2 != null) {
                root = string2.toString();
            }
            if ((string2 = this.argToValues.get("buildtype")) != null) {
                buildType = string2.toString();
            }
            if ((string2 = this.argToValues.get("appgroup")) != null) {
                appGroup = string2.toString();
            }
            if ((string2 = this.argToValues.get("type")) != null) {
                string = string2.toString();
                if (string.equalsIgnoreCase("cpp")) {
                    sourceType = Type.CPP;
                } else if (string.equalsIgnoreCase("cs")) {
                    sourceType = Type.cs;
                } else if (string.equalsIgnoreCase("java")) {
                    sourceType = Type.java;
                }
            }
            if ((string2 = this.argToValues.get("os")) != null) {
                string = string2.toString();
                if (string.equalsIgnoreCase("unix")) {
                    osType = OSType.UNIX;
                } else if (string.equalsIgnoreCase("win")) {
                    osType = OSType.WIN;
                }
            }
            if ((string2 = this.argToValues.get("usepath")) != null) {
                usePath = root + string2.toString();
            }
        }
    }

    static enum OSType {
        WIN,
        UNIX;

    }

    static enum Type {
        java,
        cs,
        CPP;

    }
}

