/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.generator;

import commvault.tools.generator.AnnotationDefValues;
import commvault.tools.generator.FieldDef;
import commvault.tools.generator.GenUtil;
import commvault.tools.generator.Generator;
import commvault.tools.generator.NameSpace;
import freemarker.template.TemplateModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ClassDef
implements TemplateModel {
    public static ClassDef LIST = new ClassDef("list", "ArrayList", false, null);
    public static ClassDef VECTOR = new ClassDef("vector", "Vector", false, null);
    public static ClassDef STRING = new ClassDef("string", null);
    public static ClassDef INT = new ClassDef("int", "Integer", "int");
    public static ClassDef BOOLEAN = new ClassDef("boolean", "Boolean", "boolean");
    public static ClassDef ENUM = new ClassDef("", null);
    public static ClassDef UINT = new ClassDef("uint", "Integer", "int");
    public static ClassDef WSTIRNG = new ClassDef("wstring", null);
    public static ClassDef LONG = new ClassDef("long", "Long", "long");
    public static ClassDef ULONG = new ClassDef("ulong", "Long", "long");
    public static ClassDef BSTRING = new ClassDef("bstring", null);
    public static ClassDef LONGLONG = new ClassDef("longlong", "Long", "long");
    public static ClassDef DOUBLE = new ClassDef("double", "Double", "double");
    public static ClassDef FLOAT = new ClassDef("float", "Float", "float");
    public static ClassDef CDATA = new ClassDef("cdata", null);
    public static ClassDef XML = new ClassDef("xml", null);
    public static ClassDef MAP = new ClassDef("map", "TreeMap", false, null);
    public static ClassDef TIME32 = new ClassDef("cv_time32_t", "Integer", "int");
    public static ClassDef TIME64 = new ClassDef("cv_time64_t", "Long", "long");
    private static boolean isWindows = true;
    public static HashMap<ClassDef, String> javaMap;
    public static HashMap<ClassDef, String> csMap;
    public static HashMap<ClassDef, String> cMap;
    private List<AnnotationDefValues> annotations = new ArrayList<AnnotationDefValues>();
    private List<ClassDef> inheritedClasses = new ArrayList<ClassDef>();
    private List<ClassDef> listOfBaseClasses = new ArrayList<ClassDef>();
    boolean primitive = true;
    boolean topLevel = true;
    String instantiationName;
    boolean enumType = false;
    private NameSpace rootNameSp;
    private String primitiveType;
    private boolean declared;
    private String functionContent;
    private String fieldXPaths = "";
    String name;
    private List<FieldDef> fields = new ArrayList<FieldDef>();
    private String id;
    String comment;

    public String getFunctionContent() {
        return this.functionContent;
    }

    public void setFunctionContent(String string) {
        this.functionContent = string;
    }

    private ClassDef(String string, String string2, boolean bl, NameSpace nameSpace) {
        this(string, string2, nameSpace);
        this.primitive = bl;
        this.declared = true;
    }

    private ClassDef(String string, String string2, NameSpace nameSpace) {
        this.name = string;
        this.instantiationName = string2;
        this.rootNameSp = nameSpace;
    }

    public String getConstantName() {
        String string = this.name.substring(0, 1).toLowerCase() + this.name.substring(1);
        return string.replaceAll("([A-Z])", "_$1").toUpperCase().trim();
    }

    public String getTagName() {
        return this.rootNameSp.getName();
    }

    public String getClassId() {
        return Integer.toString(this.rootNameSp.getId() << 24 | Integer.parseInt(this.getId()));
    }

    public int getTagId() {
        return this.rootNameSp.getId();
    }

    public ClassDef(String string, boolean bl, NameSpace nameSpace) {
        this.name = string;
        this.primitive = bl;
        this.rootNameSp = nameSpace;
    }

    private ClassDef(String string, String string2, String string3) {
        this(string, string2, (NameSpace)null);
        this.primitiveType = string3;
        this.declared = true;
    }

    private ClassDef(String string, String string2) {
        this(string, string2, (NameSpace)null);
    }

    public List<FieldDef> getFields() {
        return this.fields;
    }

    public Collection<FieldDef> getFieldDefs() {
        if (this.listOfBaseClasses.size() > 1) {
            return this.getAllFields();
        }
        return this.getFields();
    }

    public Collection<FieldDef> getAllFields() {
        HashMap<String, FieldDef> hashMap = new HashMap<String, FieldDef>();
        for (ClassDef classDef : this.listOfBaseClasses) {
            this.addUniqueFields(hashMap, classDef.getAllFields(), true);
        }
        this.addUniqueFields(hashMap, this.fields, false);
        return hashMap.values();
    }

    public String getfieldXPaths() {
        List<FieldDef> list = this.getRequiredFields(this);
        if (!list.isEmpty()) {
            this.getMandatoryXpaths(this, list, "");
        }
        return this.fieldXPaths.replaceFirst(Pattern.quote(","), "").trim();
    }

    private List<FieldDef> getRequiredFields(ClassDef classDef) {
        ArrayList<FieldDef> arrayList = new ArrayList<FieldDef>();
        for (FieldDef fieldDef : classDef.getAllFields()) {
            for (AnnotationDefValues annotationDefValues : fieldDef.getAnnotations()) {
                if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("Required")) continue;
                arrayList.add(fieldDef);
            }
        }
        return arrayList;
    }

    private void getMandatoryXpaths(ClassDef classDef, List<FieldDef> list, String string) {
        if (string == "") {
            string = "/" + classDef.getTagName() + "_" + classDef.name;
        }
        for (FieldDef fieldDef : list) {
            List<FieldDef> list2;
            if (fieldDef.isPrimitive() || fieldDef.getClassDef().isEnumType()) {
                this.fieldXPaths = this.fieldXPaths + ",\"" + string + "/@" + fieldDef.name + "\"";
                continue;
            }
            if (!csMap.containsKey(fieldDef.getTypeDef())) {
                list2 = this.getRequiredFields(fieldDef.getTypeDef());
                if (!list2.isEmpty()) {
                    this.getMandatoryXpaths(fieldDef.getTypeDef(), list2, string + "/" + fieldDef.name);
                    continue;
                }
                this.fieldXPaths = this.fieldXPaths + ",\"" + string + "/" + fieldDef.name + "\"";
                continue;
            }
            if (!fieldDef.isTemplate()) continue;
            if (fieldDef.isTemplatePrimitive() || fieldDef.isTemplateEnumType()) {
                this.fieldXPaths = this.fieldXPaths + ",\"" + string + "/" + fieldDef.name + "\"";
                continue;
            }
            if (csMap.containsKey(fieldDef.getTemplateTypeDef())) continue;
            list2 = this.getRequiredFields(fieldDef.getTemplateTypeDef());
            if (!list2.isEmpty()) {
                this.getMandatoryXpaths(fieldDef.getTemplateTypeDef(), list2, string + "/" + fieldDef.name + "[1]");
                continue;
            }
            this.fieldXPaths = this.fieldXPaths + ",\"" + string + "/" + fieldDef.name + "\"";
        }
    }

    public boolean isGenFillAnnotation() {
        if (this.annotations.size() > 0) {
            return true;
        }
        for (FieldDef object : this.fields) {
            if (object.getAnnotations().size() <= 0) continue;
            return true;
        }
        for (ClassDef classDef : this.listOfBaseClasses) {
            if (classDef.annotations.size() > 0) {
                return true;
            }
            for (FieldDef fieldDef : classDef.fields) {
                if (fieldDef.getAnnotations().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isContainsList() {
        for (FieldDef object : this.fields) {
            if (!object.isList()) continue;
            return true;
        }
        for (ClassDef classDef : this.listOfBaseClasses) {
            for (FieldDef fieldDef : classDef.fields) {
                if (!fieldDef.isList()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHasNonPrimitiveRefs() {
        for (FieldDef fieldDef : this.fields) {
            if (!fieldDef.isRef() || fieldDef.isPrimitive()) continue;
            return true;
        }
        return false;
    }

    public boolean isHasOnlyPrimitives() {
        for (FieldDef fieldDef : this.fields) {
            if (fieldDef.isPrimitive()) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyFieldHasDefaultValue() {
        for (FieldDef fieldDef : this.fields) {
            if (!fieldDef.isDefaultValueExist()) continue;
            return true;
        }
        return false;
    }

    private void addUniqueFields(Map<String, FieldDef> map, Collection<FieldDef> collection, boolean bl) {
        for (FieldDef fieldDef : collection) {
            fieldDef.inheritedField = bl;
            if (map.containsKey(fieldDef.name)) {
                map.remove(fieldDef.name);
            }
            map.put(fieldDef.name, fieldDef);
        }
    }

    public FieldDef findField(String string) {
        for (FieldDef fieldDef : this.getFields()) {
            if (!fieldDef.getName().equals(string)) continue;
            return fieldDef;
        }
        return null;
    }

    public void setFields(List<FieldDef> list) {
        this.fields = list;
    }

    public void addField(FieldDef fieldDef) {
        Object object;
        fieldDef.type.topLevel = false;
        if (fieldDef.templateType != null) {
            fieldDef.templateType.topLevel = false;
        }
        Iterator<FieldDef> iterator = this.fields.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!((FieldDef)object).name.equals(fieldDef.name)) continue;
            iterator.remove();
        }
        object = fieldDef.getAnnotations();
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            AnnotationDefValues annotationDefValues = (AnnotationDefValues)iterator2.next();
            if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("Generate")) continue;
            List<AnnotationDefValues.AnnotationValue> list = annotationDefValues.getAnnotationFieldValues();
            for (AnnotationDefValues.AnnotationValue annotationValue : list) {
                if (!annotationValue.getField().name.equalsIgnoreCase("source") || !(annotationValue.getValue().equalsIgnoreCase("GUI") ? NameSpace.type == Generator.Type.CPP || NameSpace.type == Generator.Type.cs : annotationValue.getValue().equalsIgnoreCase("GUISERVER") && NameSpace.type == Generator.Type.java)) continue;
                return;
            }
        }
        this.fields.add(fieldDef);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getId() {
        String string = "0x";
        if (this.id != null) {
            if (this.id.startsWith(string) || this.id.startsWith(string.toUpperCase())) {
                return String.valueOf(Integer.parseInt(this.id.substring(string.length()), 16));
            }
            return String.valueOf(Integer.parseInt(this.id));
        }
        return new Integer(this.name.hashCode() & 0xFFFFFF).toString();
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getSimpleName() {
        if (NameSpace.type == Generator.Type.java) {
            String string = javaMap.get(this);
            if (string != null) {
                return string;
            }
        } else if (NameSpace.type == Generator.Type.cs) {
            String string = csMap.get(this);
            if (string != null) {
                return string;
            }
        } else {
            String string = cMap.get(this);
            if (string != null) {
                if (this.name.equals("list")) {
                    return "vector";
                }
                if (this.name.equals("boolean")) {
                    return "bool";
                }
                return this.name;
            }
            if (this.enumType) {
                return "int";
            }
            return this.rootNameSp.getName() + "_" + this.name;
        }
        return this.name;
    }

    public boolean isEnumType() {
        return this.enumType;
    }

    public boolean equals(Object object) {
        return this.name.equals(((ClassDef)object).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static ClassDef create(String string, NameSpace nameSpace) {
        return ClassDef.create(string, nameSpace, false);
    }

    public static ClassDef create(String string, NameSpace nameSpace, boolean bl) {
        if (string == null) {
            return null;
        }
        for (ClassDef object : javaMap.keySet()) {
            if (!object.name.equals(string)) continue;
            return object;
        }
        Object object = nameSpace.findClassDef(string);
        if (object != null) {
            if (bl) {
                ((ClassDef)object).declared = true;
            }
            return object;
        }
        if (!bl) {
            for (NameSpace nameSpace2 : nameSpace.getIncludes()) {
                object = nameSpace2.findClassDef(string);
                if (object == null) continue;
                return object;
            }
        }
        object = new ClassDef(string, false, nameSpace);
        ((ClassDef)object).declared = bl;
        nameSpace.getClasses().add((ClassDef)object);
        return object;
    }

    public String toString() {
        return this.name;
    }

    public String getNonPrimitiveTypeName() {
        if (this.instantiationName != null) {
            return this.instantiationName;
        }
        return this.getSimpleName();
    }

    public String getAnnotation() {
        return GenUtil.getAnnotation(this.annotations);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public int getFieldCounts() {
        return this.fields.size();
    }

    public List<ClassDef> getBaseClass() {
        return this.inheritedClasses;
    }

    public List<ClassDef> getInheritedClasses() {
        return this.inheritedClasses;
    }

    public List<ClassDef> getListOfBaseClasses() {
        return this.listOfBaseClasses;
    }

    public List<AnnotationDefValues> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationDefValues> list) {
        this.annotations = list;
    }

    public Integer getBaseClassFieldsCount() {
        int n = 0;
        ClassDef classDef = this;
        while (classDef.isSingleInheritance()) {
            classDef = classDef.listOfBaseClasses.get(0);
            n += classDef.getFieldDefs().size();
        }
        return n;
    }

    public void addBaseClass(ClassDef classDef) {
        this.listOfBaseClasses.add(classDef);
    }

    public boolean isSingleInheritance() {
        return this.listOfBaseClasses.size() == 1;
    }

    public boolean isMultiInheritance() {
        return this.listOfBaseClasses.size() > 1;
    }

    public void setBaseClass(ClassDef classDef) {
        this.listOfBaseClasses.add(classDef);
    }

    public AnnotationDefValues.AnnotationValue getCommentAnnot() {
        for (AnnotationDefValues annotationDefValues : this.annotations) {
            if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("Text")) continue;
            for (AnnotationDefValues.AnnotationValue annotationValue : annotationDefValues.getAnnotationFieldValues()) {
                if (!annotationValue.getField().name.equalsIgnoreCase("comment")) continue;
                return annotationValue;
            }
        }
        return null;
    }

    public boolean canExternalise() {
        for (AnnotationDefValues annotationDefValues : this.annotations) {
            if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("Externalise")) continue;
            return true;
        }
        return false;
    }

    public boolean canExternaliseAll() {
        for (AnnotationDefValues annotationDefValues : this.annotations) {
            if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("Externalise")) continue;
            for (AnnotationDefValues.AnnotationValue annotationValue : annotationDefValues.getAnnotationFieldValues()) {
                if (!annotationValue.getField().name.equalsIgnoreCase("expandAll")) continue;
                return new Boolean(annotationValue.getUnquotedValue());
            }
        }
        return false;
    }

    public String getTextAnnotDisplayableText() {
        for (AnnotationDefValues annotationDefValues : this.annotations) {
            if (!annotationDefValues.getAnnotationDef().name.equalsIgnoreCase("Text")) continue;
            for (AnnotationDefValues.AnnotationValue annotationValue : annotationDefValues.getAnnotationFieldValues()) {
                if (!annotationValue.getField().name.equalsIgnoreCase("text")) continue;
                return annotationValue.getUnquotedValue();
            }
        }
        return null;
    }

    public String getSingleBaseName() {
        Iterator<ClassDef> iterator = this.listOfBaseClasses.iterator();
        if (iterator.hasNext()) {
            ClassDef classDef = iterator.next();
            return classDef.name;
        }
        return "";
    }

    public static void setOSType(String string) {
        isWindows = !string.equalsIgnoreCase("unix");
    }

    public boolean isGenerateForWin() {
        return isWindows;
    }

    public String getPrimitiveType() {
        return this.primitiveType;
    }

    public boolean isDeclared() {
        return this.declared;
    }

    public boolean isGenerateInCPP() {
        for (AnnotationDefValues annotationDefValues : this.annotations) {
            if (!annotationDefValues.getAnnotationDef().getName().equalsIgnoreCase("GenerateInCPP")) continue;
            return true;
        }
        return false;
    }

    public boolean isProcessingInstruction() {
        for (AnnotationDefValues annotationDefValues : this.annotations) {
            if (!annotationDefValues.getAnnotationDef().getName().equalsIgnoreCase("ProcessingInstruction")) continue;
            return true;
        }
        return false;
    }

    static {
        String string = System.getProperty("os.name");
        if (string != null && !string.startsWith("Win")) {
            WSTIRNG = new ClassDef("string", null);
            isWindows = false;
        }
        javaMap = new HashMap<ClassDef, String>(){
            {
                this.put(INT, "Integer");
                this.put(BOOLEAN, "Boolean");
                this.put(LIST, "List");
                this.put(VECTOR, "Vector");
                this.put(STRING, "String");
                this.put(WSTIRNG, "String");
                this.put(UINT, "Integer");
                this.put(LONG, "Long");
                this.put(ULONG, "Long");
                this.put(LONGLONG, "Long");
                this.put(BSTRING, "byte[]");
                this.put(DOUBLE, "Double");
                this.put(FLOAT, "Float");
                this.put(CDATA, "String");
                this.put(XML, "String");
                this.put(MAP, "TreeMap");
                this.put(TIME32, "Integer");
                this.put(TIME64, "Long");
            }
        };
        csMap = new HashMap<ClassDef, String>(){
            {
                this.put(INT, "int");
                this.put(BOOLEAN, "bool");
                this.put(LIST, "List");
                this.put(VECTOR, "Vector");
                this.put(STRING, "String");
                this.put(WSTIRNG, "String");
                this.put(UINT, "uint");
                this.put(LONG, "long");
                this.put(ULONG, "ulong");
                this.put(LONGLONG, "long");
                this.put(BSTRING, "byte[]");
                this.put(DOUBLE, "double");
                this.put(FLOAT, "float");
                this.put(CDATA, "String");
                this.put(XML, "String");
                this.put(MAP, "Dictionary");
                this.put(TIME32, "int");
                this.put(TIME64, "long");
            }
        };
        cMap = new HashMap<ClassDef, String>(){
            {
                this.put(INT, "int");
                this.put(BOOLEAN, "boolean");
                this.put(LIST, "List");
                this.put(VECTOR, "Vector");
                this.put(STRING, "String");
                this.put(WSTIRNG, "String");
                this.put(UINT, "uint");
                this.put(LONG, "long");
                this.put(ULONG, "ulong");
                this.put(LONGLONG, "long");
                this.put(BSTRING, "byte[]");
                this.put(DOUBLE, "double");
                this.put(FLOAT, "float");
                this.put(CDATA, "String");
                this.put(XML, "String");
                this.put(MAP, "map");
                this.put(TIME32, "int");
                this.put(TIME64, "long");
            }
        };
    }
}

