/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.generator;

import commvault.tools.generator.ClassDef;
import commvault.tools.generator.FieldDef;
import java.util.ArrayList;
import java.util.List;

public class AnnotationDefValues {
    ClassDef annotationDef;
    List<AnnotationValue> annotationFieldValues = new ArrayList<AnnotationValue>();
    String annotation;

    public AnnotationDefValues(ClassDef classDef) {
        this.annotationDef = classDef;
    }

    public ClassDef getAnnotationDef() {
        return this.annotationDef;
    }

    public List<AnnotationValue> getAnnotationFieldValues() {
        return this.annotationFieldValues;
    }

    public String getAnnotation() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@").append(this.annotationDef.getName());
        if (this.annotationFieldValues.size() > 0) {
            stringBuilder.append("(");
            int n = 0;
            for (AnnotationValue annotationValue : this.annotationFieldValues) {
                if (n > 0) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(annotationValue.getField().getName()).append("=");
                stringBuilder.append(annotationValue.getField().isEnumType() ? annotationValue.getField().getType() + "." + annotationValue.getValue() : annotationValue.getValue());
                ++n;
            }
            stringBuilder.append(")");
        }
        return stringBuilder.toString().replaceAll("null", "");
    }

    public void setAnnotation(String string) {
        this.annotation = string;
    }

    public static class AnnotationValue {
        private FieldDef field;
        private String value;

        public AnnotationValue(FieldDef fieldDef, String string) {
            this.field = fieldDef;
            this.value = string;
        }

        public FieldDef getField() {
            return this.field;
        }

        public String getValue() {
            return this.value;
        }

        public String getUnquotedValue() {
            if (this.value.charAt(0) == '\"' && this.value.charAt(this.value.length() - 1) == '\"') {
                String string = this.value.substring(1, this.value.length() - 1);
                return string;
            }
            return this.value;
        }
    }
}

