/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.db;

import commvault.tools.db.FieldData;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class ProcBuilder {
    private final String name;
    private final String packageName;
    private final String dbPackage;
    private final String className;
    private final String tableClass;
    private final String baseClass;
    private final Vector<FieldData> params = new Vector();

    public ProcBuilder(String string, String string2, String string3, String string4) throws Exception {
        this.packageName = string2;
        this.dbPackage = string4;
        this.baseClass = string3;
        this.name = string.toLowerCase().startsWith("dbo.") ? string.substring(4) : string;
        this.className = string + "_p";
        this.tableClass = string + "_t";
    }

    private String getPackagePath() {
        return StringUtils.replace((String)this.packageName, (String)".", (String)"/") + "/";
    }

    public String getType() {
        return "CTEDBStorageType.CTEDB_PROCEDURE";
    }

    public void addParam(FieldData fieldData) {
        this.params.add(fieldData);
    }

    public void writeClass(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package ").append(this.packageName).append(";\n\n");
        if (!this.packageName.equals(this.dbPackage)) {
            stringBuffer.append("import ").append(this.dbPackage).append(".*;\n");
        }
        stringBuffer.append("import java.util.List;\n");
        stringBuffer.append("\n");
        stringBuffer.append("public class ").append(this.className).append(" extends ");
        if (this.baseClass.length() > 0) {
            stringBuffer.append(this.baseClass);
        } else {
            stringBuffer.append("CTEDBProcedure");
        }
        stringBuffer.append(" {");
        stringBuffer.append("\n\n");
        for (int i = 0; i < this.params.size(); ++i) {
            FieldData fieldData = this.params.get(i);
            stringBuffer.append("    ");
            stringBuffer.append("public ");
            stringBuffer.append(fieldData.getDataType());
            stringBuffer.append(" ");
            stringBuffer.append(fieldData.getName());
            stringBuffer.append(" = new ");
            stringBuffer.append(fieldData.getDataType());
            stringBuffer.append("(");
            stringBuffer.append("\"").append(fieldData.getName()).append("\"").append(", ");
            stringBuffer.append(i + 1).append(", ");
            stringBuffer.append(fieldData.isPrimaryKey().toString()).append(", ");
            stringBuffer.append(fieldData.isIdentitiy().toString());
            stringBuffer.append(");");
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        if (this.baseClass.length() > 0) {
            stringBuffer.append("    ").append("public ").append(this.className).append("() {").append("\n");
            stringBuffer.append("        ").append("super();").append("\n");
            for (FieldData fieldData : this.params) {
                stringBuffer.append("        ").append("this.m_params.add(").append(fieldData.getName()).append(");\n");
            }
            stringBuffer.append("    ").append("}");
            stringBuffer.append("\n\n");
        }
        stringBuffer.append("    ").append("public ").append(this.className).append("(CTEDBConnection connection) {").append("\n");
        stringBuffer.append("        ").append("super(connection);").append("\n");
        for (FieldData fieldData : this.params) {
            stringBuffer.append("        ").append("this.m_params.add(").append(fieldData.getName()).append(");\n");
        }
        stringBuffer.append("    ").append("}");
        stringBuffer.append("\n\n");
        stringBuffer.append("    ").append("public String getName() {\n");
        stringBuffer.append("        ").append("return ").append("\"").append(this.name).append("\"").append(";\n");
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("    ").append("public CTEDBStorageType getType() {\n");
        stringBuffer.append("        ").append("return ").append(this.getType()).append(";\n");
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("    ").append("public List<").append(this.tableClass).append("> executeList() throws CTEDBException {\n");
        stringBuffer.append("        ").append("return super.executeList(new ").append(this.tableClass).append("());\n");
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("    ").append("public ").append(this.tableClass).append(" executeQuery() throws CTEDBException {\n");
        stringBuffer.append("        ").append("return (").append(this.tableClass).append(") super.executeQuery(new ").append(this.tableClass).append("());\n");
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("}");
        this.writeFile(stringBuffer.toString(), string);
    }

    private void writeFile(String string, String string2) throws Exception {
        String string3 = string2 + this.getPackagePath();
        File file = new File(string3);
        file.mkdirs();
        String string4 = string3 + this.className + ".java";
        System.out.println("writing file " + string4);
        FileWriter fileWriter = new FileWriter(string3 + this.className + ".java");
        fileWriter.write(string);
        fileWriter.close();
    }
}

