/*
 * Decompiled with CFR 0.152.
 */
package commvault.tools.db;

import commvault.tools.db.FieldData;
import java.io.File;
import java.io.FileWriter;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;

public class ClassBuilder {
    private final String name;
    private final String packageName;
    private final String dbPackage;
    private final String className;
    private final String baseClass;
    private final Vector<FieldData> fields = new Vector();

    public ClassBuilder(String string, String string2, String string3, String string4) throws Exception {
        this.packageName = string2;
        this.dbPackage = string4;
        this.name = string;
        this.baseClass = string3;
        if (string.toLowerCase().startsWith("dbo.")) {
            string = string.substring(4);
        }
        this.className = string + "_t";
    }

    public void addField(FieldData fieldData) {
        this.fields.add(fieldData);
    }

    protected String getPackagePath() {
        return this.convertPackageToPath(this.packageName);
    }

    protected String convertPackageToPath(String string) {
        return StringUtils.replace((String)string, (String)".", (String)"/") + "/";
    }

    public String getType() {
        return "CTEDBStorageType.CTEDB_TABLE";
    }

    public void writeClass(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("package ").append(this.packageName).append(";\n\n");
        if (!this.packageName.equals(this.dbPackage)) {
            stringBuffer.append("import ").append(this.dbPackage).append(".*;\n");
        }
        stringBuffer.append("import java.util.List;\n");
        stringBuffer.append("\n");
        stringBuffer.append("public class ").append(this.className).append(" extends ");
        if (this.baseClass.length() > 0) {
            stringBuffer.append(this.baseClass);
        } else {
            stringBuffer.append("CTEDBTableRow");
        }
        stringBuffer.append(" {");
        stringBuffer.append("\n\n");
        stringBuffer.append("    ").append("public static List<").append(this.className).append("> select() throws CTEDBException {\n");
        stringBuffer.append("        ").append("return new ").append(this.className).append("().executeSelect();\n");
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("    ").append("public static List<").append(this.className).append("> select(final String sWhere) throws CTEDBException {\n");
        stringBuffer.append("        ").append("return new ").append(this.className).append("().executeSelect(sWhere);\n");
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("    ").append("public static List<").append(this.className).append("> select(final String sWhere, final String sOrderBy) throws CTEDBException {\n");
        stringBuffer.append("        ").append("return new ").append(this.className).append("().executeSelect(sWhere, sOrderBy);\n");
        stringBuffer.append("    ").append("}\n\n");
        for (int i = 0; i < this.fields.size(); ++i) {
            FieldData fieldData = this.fields.get(i);
            stringBuffer.append("    ");
            stringBuffer.append("public ");
            stringBuffer.append(fieldData.getDataType());
            stringBuffer.append(" ");
            stringBuffer.append(fieldData.getName());
            stringBuffer.append(" = new ");
            stringBuffer.append(fieldData.getDataType());
            stringBuffer.append("(");
            stringBuffer.append("\"").append(fieldData.getName()).append("\"").append(", ");
            stringBuffer.append(i + 1).append(", ");
            stringBuffer.append(fieldData.isPrimaryKey().toString()).append(", ");
            stringBuffer.append(fieldData.isIdentitiy().toString());
            stringBuffer.append(");");
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        if (this.baseClass.length() > 0) {
            stringBuffer.append("    ").append("public ").append(this.className).append("() {").append("\n");
            stringBuffer.append("        ").append("super();").append("\n");
            stringBuffer.append("        ").append("this.initialize();").append("\n");
            stringBuffer.append("    ").append("}");
            stringBuffer.append("\n\n");
        }
        stringBuffer.append("    ").append("public ").append(this.className).append("(CTEDBConnection connection) {").append("\n");
        stringBuffer.append("        ").append("super(connection);").append("\n");
        stringBuffer.append("        ").append("this.initialize();").append("\n");
        stringBuffer.append("    ").append("}");
        stringBuffer.append("\n\n");
        stringBuffer.append("    ").append("protected void initialize() {\n");
        stringBuffer.append("        ").append("this.getColumnStorage().clear();\n");
        for (FieldData fieldData : this.fields) {
            stringBuffer.append("        ").append("this.getColumnStorage().add(").append(fieldData.getName()).append(");\n");
        }
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("    ").append("public String getName() {\n");
        stringBuffer.append("        ").append("return ").append("\"").append(this.name).append("\"").append(";\n");
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("    ").append("public CTEDBStorageType getType() {\n");
        stringBuffer.append("        ").append("return ").append(this.getType()).append(";\n");
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("    ").append("public ").append(this.className).append(" newInstance() {\n");
        if (this.baseClass.length() > 0) {
            stringBuffer.append("        ").append("return new ").append(this.className).append("();\n");
        } else {
            stringBuffer.append("        ").append("return new ").append(this.className).append("(this.getConnection());\n");
        }
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("    ").append("public void setValues(").append(this.className).append(" row) {\n");
        stringBuffer.append("        ").append("super.setValues(row);\n");
        stringBuffer.append("    ").append("}\n\n");
        stringBuffer.append("}");
        this.writeFile(stringBuffer.toString(), string);
    }

    private void writeFile(String string, String string2) throws Exception {
        String string3 = string2 + this.getPackagePath();
        File file = new File(string3);
        file.mkdirs();
        String string4 = string3 + this.className + ".java";
        System.out.println("writing file " + string4);
        FileWriter fileWriter = new FileWriter(string3 + this.className + ".java");
        fileWriter.write(string);
        fileWriter.close();
    }
}

