/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import java.util.List;
import workflow.types.cmd.SnapOperation;

public class OperationSnap
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationSnap.class);
    @Input(documentation="Operation to be performed on the snapshot", required=true)
    public SnapOperation operation;
    @Input(documentation="Volume Id")
    public List<String> volumeId;
    @Input(documentation="Job Id")
    public Integer jobId;
    @Input(documentation="Destination client name")
    public ClientEntity destinationClient;
    @Input(documentation="Destination path")
    public String destinationPath;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.operation == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no operation was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required operation input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation snap -o %s", this.operation.toString()));
        if (this.volumeId != null) {
            for (String string : this.volumeId) {
                stringBuffer.append(String.format(" -v '%s'", string));
            }
        }
        if (this.jobId != null) {
            stringBuffer.append(String.format(" -j %s", this.jobId));
        }
        if (this.destinationClient != null && this.destinationClient.getClientName().length() > 0) {
            stringBuffer.append(String.format(" -dc '%s'", this.destinationClient.getClientName()));
        }
        if (this.destinationPath != null && this.destinationPath.length() > 0) {
            stringBuffer.append(String.format(" -dpath '%s'", this.destinationPath));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

