/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.Answer;
import workflow.types.cmd.EncryptionAlgorithm;
import workflow.types.cmd.MediaAccess;

public class OperationSetEncryptionProps
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationSetEncryptionProps.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Encrypt Data(y|n)", required=true)
    public Answer encryptData;
    @Input(documentation="Data Encryption Algorithm(BLOWFISH|AES|SERPENT|TWOFISH|3-DES)")
    public EncryptionAlgorithm cipher;
    @Input(documentation="Key Length(128|256)")
    public Integer keyLength;
    @Input(documentation="Enable Syntetic Full (y|n)")
    public Answer synthFull;
    @Input(documentation="Direct Media Access (password|noaccess)")
    public MediaAccess mediaAccess;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        if (this.encryptData == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no encryptData was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required encryptData input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation setencryptionprops -c '%s'", this.client.getClientName()));
        if (this.encryptData == Answer.yes) {
            stringBuffer.append(" -encryptdata y");
        } else {
            stringBuffer.append(" -encryptdata n");
        }
        if (this.cipher != null) {
            stringBuffer.append(" -cipher " + this.cipher.toString());
        }
        if (this.keyLength != null) {
            stringBuffer.append(" -keylength " + this.keyLength);
        }
        if (this.synthFull != null) {
            if (this.synthFull == Answer.yes) {
                stringBuffer.append(" -synthfull y");
            } else {
                stringBuffer.append(" -synthfull n");
            }
        }
        if (this.mediaAccess != null) {
            stringBuffer.append(" -mediaaccess " + this.mediaAccess.toString());
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

