/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.ReplicationOperation;

public class OperationReplication
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationReplication.class);
    @Input(documentation="Client name")
    public ClientEntity clientName;
    @Input(documentation="Replication set name")
    public String replicationSetName;
    @Input(documentation="Replication set pair id")
    public Integer repsetPairId;
    @Input(documentation="Type of  operations set (start|startfullsync|abort|forceabort|suspend|resume)")
    public ReplicationOperation operation;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("qoperation replication");
        if (this.clientName != null && this.clientName.getClientName().length() > 0) {
            stringBuffer.append(String.format(" -c '%s'", this.clientName.getClientName()));
        }
        if (this.replicationSetName != null && this.replicationSetName.length() > 0) {
            stringBuffer.append(String.format(" -rsn '%s'", this.replicationSetName));
        }
        if (this.repsetPairId != null) {
            stringBuffer.append(" -rpi " + this.repsetPairId);
        }
        if (this.operation != null) {
            stringBuffer.append(" -o " + this.operation.toString());
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

