/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.cmd.Answer;

public class OperationRegister
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationRegister.class);
    @Input(documentation="Client host name", required=true)
    public String clientHostName;
    @Input(documentation="CommVault Communications Service port number")
    public Integer port;
    @Input(documentation="Display name override")
    public String displayName;
    @Input(documentation="")
    public Answer dock;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation register -hn '%s'", this.clientHostName));
        if (this.port != null) {
            stringBuffer.append(" -port " + this.port);
        }
        if (this.displayName != null && this.displayName.length() > 0) {
            stringBuffer.append(String.format(" -ocn '%s'", this.displayName));
        }
        if (this.dock != null) {
            stringBuffer.append(" -dock " + this.dock.toString());
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

