/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.MoveDataAgent;

public class OperationMove
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationMove.class);
    @Input(documentation="Source client computer name", required=true)
    public ClientEntity sourceClient;
    @Input(documentation="Agent type installed on source client computer", required=true)
    public MoveDataAgent dataAgent;
    @Input(documentation="Instance name to be moved", required=true)
    public String instance;
    @Input(documentation="Destination client name", required=true)
    public ClientEntity destinationClient;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.sourceClient == null || this.sourceClient.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no source client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required source client input");
            return AttemptStatus.FAILED;
        }
        if (this.destinationClient == null || this.destinationClient.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no destination client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required destination client input");
            return AttemptStatus.FAILED;
        }
        if (this.dataAgent == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no data agent provided in activity inputs");
            activityContext.setFailureReason("missing required data agent type");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation move -sc '%s' -a '%s' -i '%s' -dc '%s'", this.sourceClient.getClientName(), this.dataAgent, this.instance, this.destinationClient.getClientName()));
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

