/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.cmd.Answer;

public class OperationMerge
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationMerge.class);
    @Input(documentation="Path and Dump file name on the CommServe")
    public String dumpFile;
    @Input(documentation="Answer file name (with the path) on the client that was generated during capture")
    public String answerFile;
    @Input(documentation="User name, if database location is an UNC path")
    public String userName;
    @Input(documentation="Password, if database location is an UNC path")
    public String password;
    @Input(documentation="This option determines whether a licenses is consumed or not for the merged client.")
    public Answer consumeLicense;
    @Input(documentation="This option determines whether or not to mark the media as reusable in the new CommCell.")
    public Answer markMediaReusable;
    @Input(documentation="Alternative database restore path.")
    public String alternateDatabasePath;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation merge -dfn '%s'", this.dumpFile));
        if (this.answerFile != null && this.answerFile.length() > 0) {
            stringBuffer.append(String.format(" -afn '%s'", this.answerFile));
        }
        if (this.userName != null && this.userName.length() > 0) {
            stringBuffer.append(String.format(" -u '%s'", this.userName));
        }
        if (this.password != null && this.password.length() > 0) {
            stringBuffer.append(String.format(" -p '%s'", this.password));
        }
        if (this.consumeLicense != null) {
            if (this.consumeLicense == Answer.yes) {
                stringBuffer.append(" -cl y");
            } else {
                stringBuffer.append(" -cl n");
            }
        }
        if (this.markMediaReusable != null) {
            if (this.markMediaReusable == Answer.yes) {
                stringBuffer.append(" -rt y");
            } else {
                stringBuffer.append(" -rt n");
            }
        }
        if (this.alternateDatabasePath != null && this.alternateDatabasePath.length() > 0) {
            stringBuffer.append(String.format(" -rp '%s'", this.alternateDatabasePath));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

