/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OperationJobRetention
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationJobRetention.class);
    @Input(documentation="Job ID", required=true)
    public Integer jobId;
    @Input(documentation="Storage policy name", required=true)
    public String storagePolicy;
    @Input(documentation="Storage policy copy name", required=true)
    public String copy;
    @Input(documentation="Job to be retained (true) or not (false)")
    public boolean retained;
    @Input(documentation="Date until which job is to be retained, default is infinite")
    public Date retainUntil;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation jobretention -j %s -sp '%s' -spc '%s' -rtn %s", this.jobId, this.storagePolicy, this.copy, String.valueOf(this.retained)));
        if (this.retainUntil != null) {
            stringBuffer.append(String.format(" -rd '%s'", this.convertDate(this.retainUntil)));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    private String convertDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return simpleDateFormat.format(date);
    }
}

