/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.cmd.JobOperation;

public class OperationJobControlMA
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationJobControlMA.class);
    @Input(documentation="Operation to be performed on the job (kill, suspend, resume, changepriority or setpercentcomplete)", required=true)
    public JobOperation operation;
    @Input(documentation="MediaAgent", required=true)
    public String mediaAgent;
    @Input(documentation="Job priority")
    public Integer priority;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.operation == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no operation was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required operation input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation jobcontrol -o %s -m '%s'", this.operation.toString(), this.mediaAgent));
        if (this.priority != null) {
            stringBuffer.append(" -p " + this.priority);
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

