/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.common.workflow.ProcessStatus;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.activity.CharacterEncoding;
import commvault.cte.workflow.activity.PhaseHandler;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.EvalContext;
import commvault.cte.workflow.eval.UTFEncodingEvalutor;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.handler.DetermineInputs;
import commvault.cte.workflow.handler.DetermineTransitions;
import commvault.cte.workflow.handler.ExecuteActivity;
import commvault.cte.workflow.handler.ProcessHandler;
import commvault.cte.workflow.handler.ProcessOnEnter;
import commvault.cte.workflow.handler.ProcessOnExit;
import commvault.cte.workflow.handler.RepeatActivity;
import commvault.cte.workflow.handler.RetrieveOutputs;
import commvault.cte.workflow.handler.SetActivityInputs;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class OperationExecute
extends TokenActivity
implements CharacterEncoding,
PhaseHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationExecute.class);
    public static final Pattern AF_PARAM_CHECK = Pattern.compile("\\-af\\b", 2);
    @Input(documentation="xml input contents")
    public String inputXml;
    @Input(documentation="xml input contents", defaultValue="false")
    public Boolean escapeXml;
    @Input(documentation="command line arguments")
    public String commandArgs;
    @Output(documentation="xml output contents")
    public String outputXml;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        CharSequence charSequence;
        File file = null;
        if (this.inputXml != null && this.inputXml.length() > 0) {
            try {
                this.inputXml = WorkflowUtils.encodeXml((String)this.inputXml);
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to encode xml [" + this.inputXml + "]");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                return AttemptStatus.FAILED;
            }
            charSequence = UUID.randomUUID().toString() + ".xml";
            logger.debug(Long.valueOf(activityContext.getJobId()), "creating file [%s] to place the inputted xml contents into", new Object[]{charSequence});
            file = new File(WorkflowRegistry.getInstance().getGalaxyTempDir(), (String)charSequence);
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                if (this.inputXml != null) {
                    outputStreamWriter.write(this.inputXml);
                }
                outputStreamWriter.close();
            }
            catch (IOException iOException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to write xml to file [" + file.getAbsolutePath() + "]", (Throwable)iOException);
                EvMessageContainer evMessageContainer = new EvMessageContainer("failed to write xml to file [%s]", new Object[]{file.getAbsolutePath()});
                activityContext.setFailureReason(evMessageContainer);
                return AttemptStatus.FAILED;
            }
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append("qoperation execute");
        if (this.commandArgs != null && this.commandArgs.length() > 0) {
            if (AF_PARAM_CHECK.matcher(this.commandArgs).find()) {
                if (file != null) {
                    logger.info(Long.valueOf(activityContext.getJobId()), "ignoring inputXml parameter since -af parameter was passed into the commandArgs parameter");
                }
                ((StringBuffer)charSequence).append(String.format(" %s", this.commandArgs));
            } else {
                if (file != null) {
                    ((StringBuffer)charSequence).append(String.format(" -af '%s'", file.getAbsolutePath()));
                }
                ((StringBuffer)charSequence).append(String.format(" %s", this.commandArgs));
            }
        } else if (file != null) {
            ((StringBuffer)charSequence).append(String.format(" -af '%s'", file.getAbsolutePath()));
        }
        try {
            this.outputXml = this.execute((StringBuffer)charSequence, activityContext);
        }
        catch (EvFailureException evFailureException) {
            if (this.exitCode > 2) {
                this.outputXml = this.commandOutput;
            }
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            AttemptStatus attemptStatus = AttemptStatus.FAILED;
            return attemptStatus;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return AttemptStatus.SUCCESS;
    }

    public ProcessHandler[] getExecutionPhases() {
        return new ProcessHandler[]{new DetermineInputs(), new ExecuteProcessInputs(), new SetActivityInputs(), new ProcessOnEnter(), new ExecuteActivity(), new ProcessOnExit(), new RetrieveOutputs(), new RepeatActivity(), new DetermineTransitions()};
    }

    public static class XMLEscapeEvaluator
    extends UTFEncodingEvalutor {
        public XMLEscapeEvaluator(EvalContext evalContext) {
            super(evalContext);
        }

        protected String getStringValue(Object object) {
            return StringEscapeUtils.escapeXml((String)super.getStringValue(object));
        }
    }

    public static class ExecuteProcessInputs
    implements ProcessHandler {
        public void executeHandler(ActivityContext activityContext) throws InterruptedException {
            WorkflowElement workflowElement = activityContext.getActivityInputs();
            WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
            WorkflowElement workflowElement2 = workflowElement.getChild("escapeXml");
            boolean bl = workflowElement2 == null || workflowElement2.getText().length() == 0 ? false : Boolean.parseBoolean(workflowElement2.getText());
            XMLEscapeEvaluator xMLEscapeEvaluator = bl ? new XMLEscapeEvaluator(activityContext.getEvaluator()) : new UTFEncodingEvalutor(activityContext.getEvaluator());
            try {
                logger.debug(Long.valueOf(activityContext.getJobId()), "begin processing expressions for encoded inputs [%s]", new Object[]{workflowElement});
                for (WorkflowElement workflowElement3 : workflowElement.getChildren()) {
                    if (workflowElement3.getName().equalsIgnoreCase("inputXml")) {
                        xMLEscapeEvaluator.processChildElement(workflowElement3);
                        continue;
                    }
                    workflowEvaluator.processChildElement(workflowElement3);
                }
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "error processing expressions in activity inputs [" + workflowElement + "]");
                activityContext.setFailureReason(evFailureException.getMessageContainer());
                activityContext.setStatus(ProcessStatus.PENDING);
                return;
            }
            activityContext.setActivityInputs(workflowElement);
        }
    }
}

