/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.cmd.DRType;

public class OperationDRBackup
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationDRBackup.class);
    @Input(documentation="Backup type (Q_FULL|Q_DIFF)", required=true)
    public DRType type;
    @Output
    public int jobId;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.type == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no type was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required type input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation drbackup -t %s", this.type.toString()));
        try {
            String string = this.execute(stringBuffer, activityContext);
            String string2 = CommandUtil.parseFirstValue(string);
            if (string2 != null) {
                this.jobId = Integer.parseInt(string2);
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

