/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.ReportInformationType;

public class OperationCheckReady
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationCheckReady.class);
    @Input(documentation="Client computer name")
    public ClientEntity client;
    @Input(documentation="Summary|Detail")
    public ReportInformationType reportType;
    @Output(documentation="the html formatted readiness report")
    public String htmlReport;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation checkready -c '%s'", this.client.getClientName()));
        if (this.reportType != null) {
            if (this.reportType == ReportInformationType.Detail) {
                stringBuffer.append(" -dt");
            } else if (this.reportType == ReportInformationType.Summary) {
                stringBuffer.append(" -sm");
            }
        }
        try {
            this.htmlReport = this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

