/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OperationCapture
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationCapture.class);
    @Input(documentation="Name of the client to capture")
    public ClientEntity client;
    @Input(documentation="Full path and the dump file name on the CommServe")
    public String dumpFile;
    @Input(documentation="Name of the database from which you wish to capture data.")
    public String databaseName;
    @Input(documentation="Full path of the answer file name on the local Client")
    public String answerFile;
    @Input(documentation="Start date and time from which data will be captured.")
    public Date startTime;
    @Input(documentation="End date and time until which data must be captured.")
    public Date endTime;
    @Input(documentation="User name, if database location is an UNC path")
    public String userName;
    @Input(documentation="Password, if database location is an UNC path")
    public String password;
    @Input(documentation="Alternative database restore path.")
    public String alternateDatabasePath;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation capture -c '%s' -dfn '%s'", this.client.getClientName(), this.dumpFile));
        if (this.databaseName != null && this.databaseName.length() > 0) {
            stringBuffer.append(String.format(" -dbn '%s'", this.databaseName));
        }
        if (this.answerFile != null && this.answerFile.length() > 0) {
            stringBuffer.append(String.format(" -afn '%s'", this.answerFile));
        }
        if (this.startTime != null) {
            stringBuffer.append(String.format(" -st '%s'", this.convertDate(this.startTime)));
        }
        if (this.endTime != null) {
            stringBuffer.append(String.format(" -et '%s'", this.convertDate(this.endTime)));
        }
        if (this.userName != null && this.userName.length() > 0) {
            stringBuffer.append(String.format(" -u '%s'", this.userName));
        }
        if (this.password != null && this.password.length() > 0) {
            stringBuffer.append(String.format(" -u '%s'", this.password));
        }
        if (this.alternateDatabasePath != null && this.alternateDatabasePath.length() > 0) {
            stringBuffer.append(String.format(" -rp '%s'", this.alternateDatabasePath));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }

    private String convertDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return simpleDateFormat.format(date);
    }
}

