/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.BackupType;
import workflow.types.cmd.DataAgent;

public class OperationBackup
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationBackup.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer", required=true)
    public DataAgent dataAgent;
    @Input(documentation="Backup set name, required for a few agents")
    public String backupSet;
    @Input(documentation="Name of the subclient to be backed up", required=true)
    public String subClient;
    @Input(documentation="Instance name, required for a few agents")
    public String instance;
    @Input(documentation="Type of backup", required=true)
    public BackupType backupType;
    @Output
    public Integer jobId;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        if (this.backupType == null) {
            this.backupType = BackupType.Q_FULL;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation backup -c '%s' -a '%s' -s '%s' -t %s", this.client.getClientName(), this.dataAgent, this.subClient, this.backupType));
        if (this.backupSet != null && this.backupSet.length() > 0) {
            stringBuffer.append(String.format(" -b '%s'", this.backupSet));
        }
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        try {
            String string = this.execute(stringBuffer, activityContext);
            String string2 = CommandUtil.parseFirstValue(string);
            if (string2 != null) {
                this.jobId = Integer.parseInt(string2);
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

