/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.operation;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.cmd.FileType;

public class OperationAgeData
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(OperationAgeData.class);
    @Input(documentation="Flag to delete jobs by job ID", defaultValue="false")
    public boolean delByJobId;
    @Input(documentation="Job ID")
    public Integer jobId;
    @Input(documentation="Name of the storage policy")
    public String storagePolicy;
    @Input(documentation="Name of the storage policy copy")
    public String copy;
    @Input(documentation="File type Q_LOG|Q_DATA|Q_DATA_LOG")
    public FileType fileType;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qoperation agedata", new Object[0]));
        if (this.delByJobId) {
            if (this.fileType == null) {
                logger.error(Long.valueOf(activityContext.getJobId()), "no file type was supplied via the inputs into the activity");
                activityContext.setFailureReason("missing required file type input");
                return AttemptStatus.FAILED;
            }
            stringBuffer.append(" -delbyjobid");
            if (this.jobId != null) {
                stringBuffer.append(" -j " + this.jobId);
            }
            if (this.storagePolicy != null && this.storagePolicy.length() > 0) {
                stringBuffer.append(String.format(" -sp '%s'", this.storagePolicy));
            }
            if (this.copy != null && this.copy.length() > 0) {
                stringBuffer.append(String.format(" -spc '%s'", this.copy));
            }
            stringBuffer.append(" -ft " + this.fileType.toString());
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

