/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.modify;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.activities.cmd.create.CreateSPCopy;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;

public class ModifySPCopy
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateSPCopy.class);
    @Input(documentation="Storage policy name", required=true)
    public String storagePolicy;
    @Input(documentation="Secondary copy name to be modified", required=true)
    public String copy;
    @Input(documentation="The operation to perform", required=true)
    public String operation;
    @Input(documentation="MediaAgent name", required=true)
    public String mediaAgent;
    @Input(documentation="Media library name", required=true)
    public String library;
    @Input(documentation="Drive pool name to which backup data of the Primary copy is directed", required=false)
    public String drivePool;
    @Input(documentation="Name of the scratch pool from which the copy obtains new media", required=false)
    public String scratchPool;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qmodify spcopy -sp '%s' -spc '%s' -o '%s' -m '%s' -l '%s'", this.storagePolicy, this.copy, this.operation, this.mediaAgent, this.library));
        if (this.drivePool != null && this.drivePool.length() > 0) {
            stringBuffer.append(String.format(" -d '%s'", this.drivePool));
        }
        if (this.scratchPool != null && this.scratchPool.length() > 0) {
            stringBuffer.append(String.format(" -srp '%s'", this.scratchPool));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

