/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.modify;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.cmd.AppendOverwrite;
import workflow.types.cmd.OSType;

public class ModifyGlobalFilter
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ModifyGlobalFilter.class);
    @Input(documentation="Operation to be performed on the globalfilter", required=true)
    public AppendOverwrite operation;
    @Input(documentation="Subclient type Windows|UNIX|Netware", required=true)
    public OSType subClientType;
    @Input(documentation="Reads files, folders, and patterns to be excluded from the file.", required=true)
    public String filterFile;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.operation == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no operation was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required operation input");
            return AttemptStatus.FAILED;
        }
        if (this.subClientType == null) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no subclient type was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required subclient type input");
            return AttemptStatus.FAILED;
        }
        if (this.filterFile == null || this.filterFile.length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no filter file provided in activity inputs");
            activityContext.setFailureReason("missing required filter file input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qmodify globalfilter -o %s -t %s -ff '%s'", this.operation.toString(), this.subClientType.toString(), this.filterFile));
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

