/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.list;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.util.List;

public class ListScratchPool
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListScratchPool.class);
    @Input(documentation="Library name", required=true)
    public String library;
    @Input(documentation="MediaAgent Name")
    public String mediaAgent;
    @Output(documentation="")
    public List<String> scratchPool;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qlist scratchpool -l '%s'", this.library));
        if (this.mediaAgent != null && this.mediaAgent.length() > 0) {
            stringBuffer.append(String.format(" -m '%s'", this.mediaAgent));
        }
        try {
            String string = this.execute(stringBuffer, activityContext);
            this.scratchPool = CommandUtil.parseSingleValue(string);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

