/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.list;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import java.util.List;
import workflow.types.cmd.DataAgent;

public class ListSchedulePolicy
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListSchedulePolicy.class);
    @Input(documentation="Client computer name")
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer")
    public DataAgent dataAgent;
    @Input(documentation="Instance name")
    public String instance;
    @Input(documentation="Backup set name")
    public String backupSet;
    @Input(documentation="Subclient name")
    public String subClient;
    @Output(documentation="")
    public List<String> schedulePolicy;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("qlist schedulepolicy");
        if (this.client != null && this.client.getClientName().length() > 0) {
            stringBuffer.append(String.format(" -c '%s'", this.client.getClientName()));
        }
        if (this.dataAgent != null) {
            stringBuffer.append(String.format(" -a '%s'", this.dataAgent));
        }
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        if (this.backupSet != null && this.backupSet.length() > 0) {
            stringBuffer.append(String.format(" -b '%s'", this.backupSet));
        }
        if (this.subClient != null && this.subClient.length() > 0) {
            stringBuffer.append(String.format(" -s '%s'", this.subClient));
        }
        try {
            String string = this.execute(stringBuffer, activityContext);
            this.schedulePolicy = CommandUtil.parseSingleValue(string);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

