/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.list;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import java.util.List;

public class ListReplicationSet
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListReplicationSet.class);
    @Input(documentation="Client computer name")
    public ClientEntity client;
    @Output(documentation="")
    public List<String> replicationSet;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("qlist replicationset");
        if (this.client != null || this.client.getClientName().length() > 0) {
            stringBuffer.append(String.format(" -c '%s'", this.client.getClientName()));
        }
        try {
            String string = this.execute(stringBuffer, activityContext);
            this.replicationSet = CommandUtil.parseSingleValue(string);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

