/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.list;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import java.util.List;
import workflow.types.cmd.MediaDetails;

public class ListMedia
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListMedia.class);
    @Input(documentation="Job ID ")
    public Integer jobId;
    @Input(documentation="Storage policy name ")
    public String storagePolicy;
    @Input(documentation="Storage policy copy name")
    public String copy;
    @Input(documentation="Library name")
    public String library;
    @Input(documentation="Scratch pool name")
    public String scratchPool;
    @Input(documentation="Export location")
    public String exportLocation;
    @Output(documentation="")
    public List<MediaDetails> media;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("qlist media");
        if (this.jobId != null && this.jobId > 0) {
            stringBuffer.append(" -j " + this.jobId);
        }
        if (this.storagePolicy != null && this.storagePolicy.length() > 0) {
            stringBuffer.append(String.format(" -sp '%s'", this.storagePolicy));
        }
        if (this.copy != null && this.copy.length() > 0) {
            stringBuffer.append(String.format(" -spc '%s'", this.copy));
        }
        if (this.library != null && this.library.length() > 0) {
            stringBuffer.append(String.format(" -l '%s'", this.library));
        }
        if (this.scratchPool != null && this.scratchPool.length() > 0) {
            stringBuffer.append(String.format(" -srp '%s'", this.scratchPool));
        }
        if (this.exportLocation != null && this.exportLocation.length() > 0) {
            stringBuffer.append(String.format(" -loc '%s'", this.exportLocation));
        }
        this.media = new ArrayList<MediaDetails>();
        try {
            String string = this.execute(stringBuffer, activityContext);
            List<CommandUtil.RowData> list = CommandUtil.parseColumnValues(string);
            for (CommandUtil.RowData rowData : list) {
                MediaDetails mediaDetails = new MediaDetails();
                mediaDetails.barCode = rowData.getColumn("BARCODE");
                mediaDetails.location = rowData.getColumn("LOCATION");
                mediaDetails.library = rowData.getColumn("LIBRARY");
                mediaDetails.storagePolicy = rowData.getColumn("STORAGEPOLICY");
                mediaDetails.copyName = rowData.getColumn("COPYNAME");
                this.media.add(mediaDetails);
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

