/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.list;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.InputOutput;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import workflow.types.cmd.DataAgent;

public class ListLastJob
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListLastJob.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer", required=true)
    public DataAgent dataAgent;
    @InputOutput(documentation="Instance name")
    public String instance;
    @InputOutput(documentation="Backup set name", required=true)
    public String backupSet;
    @InputOutput(documentation="Subclient name", required=true)
    public String subClient;
    @InputOutput(documentation="Job status [Completed|Failed|Killed]")
    public String jobStatus;
    @Output(documentation="")
    public Integer jobId;
    @Output(documentation="")
    public String storagePolicy;
    @Output(documentation="")
    public String appType;
    @Output(documentation="")
    public Date startTime;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        String string = this.dataAgent == null ? "" : this.dataAgent.toString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qlist lastjob -c '%s' -a '%s' -b '%s' -s '%s'", this.client.getClientName(), string, this.backupSet, this.subClient));
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        if (this.jobStatus != null && this.jobStatus.length() > 0) {
            stringBuffer.append(String.format(" -js '%s'", this.jobStatus));
        }
        try {
            String string2 = this.execute(stringBuffer, activityContext);
            List<CommandUtil.RowData> list = CommandUtil.parseColumnValues(string2);
            if (list.size() > 0) {
                this.jobId = Integer.parseInt(list.get(0).getColumn("JOBID"));
                this.jobStatus = list.get(0).getColumn("STATUS");
                this.storagePolicy = list.get(0).getColumn("STORAGEPOLICY");
                this.appType = list.get(0).getColumn("APPTYPE");
                this.backupSet = list.get(0).getColumn("BACKUPSET");
                this.subClient = list.get(0).getColumn("SUBCLIENT");
                this.instance = list.get(0).getColumn("INSTANCE");
                String[] stringArray = new String[]{"yyyy/MM/dd HH:mm:ss", "MM/dd/yyyy HH:mm:ss"};
                String string3 = list.get(0).getColumn("START TIME");
                if (string3 != null) {
                    try {
                        this.startTime = DateUtils.parseDate((String)string3, (String[])stringArray);
                    }
                    catch (ParseException parseException) {
                        logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse date value from string [" + string3 + "] using format [" + stringArray + "]", (Throwable)parseException);
                    }
                }
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

