/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.list;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import java.util.List;
import workflow.types.cmd.DataAgent;

public class ListJobSummary
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListJobSummary.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer")
    public DataAgent dataAgent;
    @Input(documentation="Instance name")
    public String instance;
    @Input(documentation="Backup set name")
    public String backupSet;
    @Input(documentation="Subclient name")
    public String subClient;
    @Output(documentation="")
    public Integer runningJobs;
    @Output(documentation="")
    public Integer pendingJobs;
    @Output(documentation="")
    public Integer waitingJobs;
    @Output(documentation="")
    public Integer queuedJobs;
    @Output(documentation="")
    public Integer suspendedJobs;
    @Output(documentation="")
    public Integer totalJobs;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("qlist jobsummary");
        if (this.client != null && this.client.getClientName().length() > 0) {
            stringBuffer.append(String.format(" -c '%s'", this.client.getClientName()));
        }
        if (this.dataAgent != null) {
            stringBuffer.append(String.format(" -a '%s'", this.dataAgent));
        }
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        if (this.backupSet != null && this.backupSet.length() > 0) {
            stringBuffer.append(String.format(" -b '%s'", this.backupSet));
        }
        if (this.subClient != null && this.subClient.length() > 0) {
            stringBuffer.append(String.format(" -s '%s'", this.subClient));
        }
        try {
            String string = this.execute(stringBuffer, activityContext);
            List<CommandUtil.RowData> list = CommandUtil.parseColumnValues(string);
            if (list.size() > 0) {
                this.runningJobs = Integer.parseInt(list.get(0).getColumn("RUNNING"));
                this.pendingJobs = Integer.parseInt(list.get(0).getColumn("PENDING"));
                this.waitingJobs = Integer.parseInt(list.get(0).getColumn("WAITING"));
                this.queuedJobs = Integer.parseInt(list.get(0).getColumn("QUEUED"));
                this.suspendedJobs = Integer.parseInt(list.get(0).getColumn("SUSPENDED"));
                this.totalJobs = Integer.parseInt(list.get(0).getColumn("TOTAL"));
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

