/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.list;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import java.util.ArrayList;
import java.util.List;
import workflow.types.cmd.DataAgent;
import workflow.types.cmd.JobDetails;

public class ListJob
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListJob.class);
    @Input(documentation="Job ID")
    public Integer jobId;
    @Input(documentation="Filter by job type (Backup|Restore)")
    public String jobType;
    @Input(documentation="Filter by job status (Running|Suspended|Waiting|Pending)")
    public String jobStatus;
    @Input(documentation="Client computer name")
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer")
    public DataAgent dataAgent;
    @Input(documentation="Instance name")
    public String instance;
    @Input(documentation="Backup set name")
    public String backupSet;
    @Input(documentation="Subclient name")
    public String subClient;
    @Output(documentation="")
    public List<JobDetails> job;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("qlist job");
        if (this.jobId != null && this.jobId > 0) {
            stringBuffer.append(" -j " + this.jobId);
        }
        if (this.jobType != null && this.jobType.length() > 0) {
            stringBuffer.append(String.format(" -jt '%s'", this.jobType));
        }
        if (this.jobStatus != null && this.jobStatus.length() > 0) {
            stringBuffer.append(String.format(" -js '%s'", this.jobStatus));
        }
        if (this.client != null && this.client.getClientName().length() > 0) {
            stringBuffer.append(String.format(" -c '%s'", this.client.getClientName()));
        }
        if (this.dataAgent != null) {
            stringBuffer.append(String.format(" -a '%s'", this.dataAgent));
        }
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        if (this.backupSet != null && this.backupSet.length() > 0) {
            stringBuffer.append(String.format(" -b '%s'", this.backupSet));
        }
        if (this.subClient != null && this.subClient.length() > 0) {
            stringBuffer.append(String.format(" -s '%s'", this.subClient));
        }
        this.job = new ArrayList<JobDetails>();
        try {
            String string = this.execute(stringBuffer, activityContext);
            List<CommandUtil.RowData> list = CommandUtil.parseColumnValues(string);
            for (CommandUtil.RowData rowData : list) {
                JobDetails jobDetails = new JobDetails();
                jobDetails.jobId = Integer.parseInt(rowData.getColumn("JOBID"));
                jobDetails.jobType = rowData.getColumn("OPERATION");
                jobDetails.phase = rowData.getColumn("PHASE");
                jobDetails.status = rowData.getColumn("STATUS");
                this.job.add(jobDetails);
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

