/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.list;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import java.util.List;
import workflow.types.cmd.ClientDetails;

public class ListClient
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListClient.class);
    @Output(documentation="")
    public List<ClientDetails> client;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("qlist client");
        this.client = new ArrayList<ClientDetails>();
        try {
            String string = this.execute(stringBuffer, activityContext);
            List<CommandUtil.RowData> list = CommandUtil.parseColumnValues(string);
            for (CommandUtil.RowData rowData : list) {
                ClientDetails clientDetails = new ClientDetails();
                clientDetails.client = rowData.getColumn("NAME");
                clientDetails.operatingSystem = rowData.getColumn("OS");
                clientDetails.active = CommandUtil.parseAnswer(rowData.getColumn("ACTIVE"));
                this.client.add(clientDetails);
            }
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

