/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.list;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandUtil;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import java.util.List;
import workflow.types.cmd.DataAgent;

public class ListBackupSet
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListBackupSet.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer", required=true)
    public DataAgent dataAgent;
    @Input(documentation="Instance name, required for a few agents")
    public String instance;
    @Output(documentation="")
    public List<String> backupSet;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        String string = this.dataAgent == null ? "" : this.dataAgent.toString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qlist backupset -c '%s' -a '%s'", this.client.getClientName(), string));
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        try {
            String string2 = this.execute(stringBuffer, activityContext);
            this.backupSet = CommandUtil.parseSingleValue(string2);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

