/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.delete;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.activities.cmd.delete.DeleteClient;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.DataAgent;

public class DeleteInstance
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(DeleteClient.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="iDataAgent to be deleted", required=true)
    public DataAgent dataAgent;
    @Input(documentation="name of the instance to be deleted", required=true)
    public String instance;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qdelete instance -c '%s' -a '%s' -i '%s'", this.client.getClientName(), this.dataAgent, this.instance));
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

