/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.create;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.cmd.Answer;

public class CreateUser
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateUser.class);
    @Input(documentation="User name", required=true)
    public String userName;
    @Input(documentation="Password (in plain text)")
    public String password;
    @Input(documentation="Full name")
    public String fullName;
    @Input(documentation="Description")
    public String description;
    @Input(documentation="Email ID")
    public String email;
    @Input(documentation="Login enable (y|n)")
    public Answer loginEnabled;
    @Input(documentation="Password aging (number of days)")
    public Integer agePassword;
    @Input(documentation="User groups")
    public String userGroups;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qcreate user -u '%s'", this.userName));
        if (this.password != null && this.password.length() > 0) {
            stringBuffer.append(String.format(" -p '%s'", this.password));
        }
        if (this.fullName != null && this.fullName.length() > 0) {
            stringBuffer.append(String.format(" -fn '%s'", this.fullName));
        }
        if (this.description != null && this.description.length() > 0) {
            stringBuffer.append(String.format(" -desc '%s'", this.description));
        }
        if (this.email != null && this.email.length() > 0) {
            stringBuffer.append(String.format(" -e '%s'", this.email));
        }
        if (this.loginEnabled != null) {
            if (this.loginEnabled == Answer.yes) {
                stringBuffer.append(" -en y");
            } else {
                stringBuffer.append(" -en n");
            }
        }
        if (this.agePassword != null) {
            stringBuffer.append(" -pa " + this.agePassword);
        }
        if (this.userGroups != null && this.userGroups.length() > 0) {
            stringBuffer.append(String.format(" -ug '%s'", this.userGroups));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

