/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.create;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.activities.cmd.create.CreateBackupset;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import java.util.List;
import workflow.types.cmd.Answer;
import workflow.types.cmd.DataAgent;

public class CreateSubclient
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateBackupset.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Agent type installed on client computer", required=true)
    public DataAgent dataAgent;
    @Input(documentation="Backup set name, required for certain agents", required=true)
    public String backupSet;
    @Input(documentation="Instance name, required for certain agents")
    public String instance;
    @Input(documentation="Name of the subclient to be created", required=true)
    public String subclient;
    @Input(documentation="Name of the storage policy to be associated with the subclient", required=true)
    public String storagePolicy;
    @Input(documentation="File/Directory Path(s) to be included as content in the new subclient.", required=true)
    public List<String> contentPath;
    @Input(documentation="Does File/Directory Paths have wildcards (y|n)")
    public Answer wildCards;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        if (this.contentPath == null || this.contentPath.size() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no content was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required content input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qcreate subclient -c '%s' -a '%s' -b '%s' -n '%s' -sp '%s'", this.client.getClientName(), this.dataAgent, this.backupSet, this.subclient, this.storagePolicy));
        if (this.instance != null && this.instance.length() > 0) {
            stringBuffer.append(String.format(" -i '%s'", this.instance));
        }
        for (String string : this.contentPath) {
            stringBuffer.append(String.format(" -f '%s'", string));
        }
        if (this.wildCards != null) {
            if (this.wildCards == Answer.yes) {
                stringBuffer.append(" -wc y");
            } else {
                stringBuffer.append(" -wc n");
            }
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

