/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.create;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;

public class CreateStoragePolicy
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateStoragePolicy.class);
    @Input(documentation="Storage policy name to be created", required=true)
    public String storagePolicy;
    @Input(documentation="MediaAgent name", required=true)
    public String mediaAgent;
    @Input(documentation="Media library name", required=true)
    public String library;
    @Input(documentation="Drive pool name to which backup data of Primary copy is directed", required=true)
    public String drivePool;
    @Input(documentation="Name of the scratch pool from which the copy obtains new media", required=true)
    public String scratchPool;
    @Input(documentation="Incremental storage policy name to be associated with the new storage policy name")
    public String incStoragePolicy;
    @Input(documentation="Deduplication path")
    public String dedupPath;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qcreate sp -sp '%s' -m '%s' -l '%s' -d '%s' -srp '%s'", this.storagePolicy, this.mediaAgent, this.library, this.drivePool, this.scratchPool));
        if (this.incStoragePolicy != null && this.incStoragePolicy.length() > 0) {
            stringBuffer.append(String.format(" -isp '%s'", this.incStoragePolicy));
        }
        if (this.dedupPath != null && this.dedupPath.length() > 0) {
            stringBuffer.append(String.format(" -ddpath '%s'", this.dedupPath));
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

