/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.create;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.TokenActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.cmd.Answer;
import workflow.types.cmd.DataAgent;

public class CreateReplicationPair
extends TokenActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateReplicationPair.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="DataAgent name", required=true)
    public DataAgent dataAgent;
    @Input(documentation="Replication set name", required=true)
    public String replicationSetName;
    @Input(documentation="Source path", required=true)
    public String sourcePath;
    @Input(documentation="Destination Path")
    public String destinationPath;
    @Input(documentation="User Common Base Folder (y/n)")
    public Answer useCommonBaseFolder;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            activityContext.setFailureReason("missing required client input");
            return AttemptStatus.FAILED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qcreate replicationpair -c '%s' -a '%s' -repset '%s' -spath '%s'", this.client.getClientName(), this.dataAgent, this.replicationSetName, this.sourcePath));
        if (this.destinationPath != null && this.destinationPath.length() > 0) {
            stringBuffer.append(String.format(" -dpath '%s'", this.destinationPath));
        }
        if (this.useCommonBaseFolder != null) {
            if (this.useCommonBaseFolder == Answer.yes) {
                stringBuffer.append(" -commonbasefolder y");
            } else {
                stringBuffer.append(" -commonbasefolder n");
            }
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

