/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.create;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.create.CreateInstance;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.cmd.Answer;

public class CreateInstanceSQL
extends CreateInstance {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateInstanceSQL.class);
    @Input(documentation="Overrides the CommServe settings (yes|no)")
    public Answer overrideCSSettings;
    @Input(documentation="Local System Account (yes|no)")
    public Answer localSysAccount;
    @Input(documentation="SQL USER Name")
    public String user;
    @Input(documentation="Password (in plain text)")
    public String password;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        StringBuffer stringBuffer;
        try {
            stringBuffer = this.createCommand(activityContext, "Q_MSSQL");
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        if (this.overrideCSSettings != null) {
            stringBuffer.append(String.format(" -o '%s'", this.overrideCSSettings));
        }
        if (this.localSysAccount != null) {
            stringBuffer.append(String.format(" -lsa '%s'", this.localSysAccount));
        }
        if (this.user != null && this.user.length() > 0) {
            stringBuffer.append(String.format(" -su '%s'", this.user));
        }
        if (this.password != null && this.password.length() > 0) {
            stringBuffer.append(" -p " + this.password);
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        return AttemptStatus.SUCCESS;
    }
}

