/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd.create;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.activities.cmd.ArgumentActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;

public abstract class CreateInstance
extends ArgumentActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CreateInstance.class);
    @Input(documentation="Client computer name", required=true)
    public ClientEntity client;
    @Input(documentation="Name of the instance to be created for the agent or On Demand instance", required=true)
    public String instance;
    @Input(documentation="Default storage policy name", required=true)
    public String defaultStoragePolicy;
    @Input(documentation="Command line storage policy name", required=true)
    public String cmdLineStoragePolicy;
    @Input(documentation="Log storage policy name", required=true)
    public String logStoragePolicy;

    protected StringBuffer createCommand(ActivityContext activityContext, String string) throws EvFailureException {
        if (this.client == null || this.client.getClientName().length() == 0) {
            logger.error(Long.valueOf(activityContext.getJobId()), "no client was supplied via the inputs into the activity");
            throw new EvFailureException(new EvMessageContainer("invalid client"));
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qcreate instance -c '%s' -a '%s' -n '%s'", this.client.getClientName(), string, this.instance));
        if (this.defaultStoragePolicy != null && this.defaultStoragePolicy.length() > 0) {
            stringBuffer.append(String.format(" -dsp '%s'", this.defaultStoragePolicy));
        }
        if (this.cmdLineStoragePolicy != null && this.cmdLineStoragePolicy.length() > 0) {
            stringBuffer.append(String.format(" -csp '%s'", this.cmdLineStoragePolicy));
        }
        if (this.logStoragePolicy != null && this.logStoragePolicy.length() > 0) {
            stringBuffer.append(String.format(" -lsp '%s'", this.logStoragePolicy));
        }
        return stringBuffer;
    }
}

