/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.cmd.CommandActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.InputOutput;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import workflow.types.EncryptedString;

public class Login
extends CommandActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(Login.class);
    @Input(documentation="the host name of the commcell to log into")
    public String commCellName;
    @Input(documentation="the client name of the commcell to log into")
    public String commCellClientName;
    @Input(documentation="User name")
    public String userName;
    @Input(documentation="User password")
    public EncryptedString password;
    @InputOutput(documentation="Token file")
    public String tokenFile;
    @Output(documentation="Login token")
    public String token;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        boolean bl = false;
        String string = "";
        if (this.password != null) {
            string = this.password.getEncryptedText();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("qlogin -u '%s' -ps '%s'", this.userName, string));
        if (this.commCellName != null && this.commCellName.length() > 0) {
            stringBuffer.append(String.format(" -cs '%s'", this.commCellName));
        }
        if (this.commCellClientName != null && this.commCellClientName.length() > 0) {
            stringBuffer.append(String.format(" -csn '%s'", this.commCellClientName));
        }
        if (this.tokenFile != null && this.tokenFile.length() > 0) {
            stringBuffer.append(String.format(" -f '%s'", this.tokenFile));
        } else {
            bl = true;
            stringBuffer.append(" -gt");
        }
        try {
            this.execute(stringBuffer, activityContext);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        if (bl) {
            this.token = this.commandOutput;
        }
        return AttemptStatus.SUCCESS;
    }
}

