/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd;

import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class CommandUtil {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CommandUtil.class);

    public static Boolean parseAnswer(String string) {
        if (string == null) {
            return null;
        }
        return string.equalsIgnoreCase("yes");
    }

    public static String parseFirstValue(String string) {
        Scanner scanner = new Scanner(string);
        String string2 = null;
        while (scanner.hasNextLine()) {
            String string3 = scanner.nextLine().trim();
            if (string3.length() <= 0) continue;
            string2 = string3;
            break;
        }
        scanner.close();
        return string2;
    }

    public static List<String> parseSingleValue(String string) {
        Scanner scanner = new Scanner(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (scanner.hasNextLine()) {
            String string2 = scanner.nextLine().trim();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        scanner.close();
        return arrayList;
    }

    public static List<RowData> parseColumnValues(String string) {
        boolean bl = false;
        Scanner scanner = new Scanner(string);
        ArrayList<ColumnData> arrayList = new ArrayList<ColumnData>();
        ArrayList<RowData> arrayList2 = new ArrayList<RowData>();
        while (scanner.hasNextLine()) {
            String string2 = scanner.nextLine().trim();
            if (string2.length() <= 0 || string2.startsWith("--")) continue;
            if (!bl) {
                CommandUtil.parseNextColumn(arrayList, string2, 0);
                bl = true;
                continue;
            }
            RowData rowData = new RowData();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = i < arrayList.size() - 1 ? string2.substring(((ColumnData)arrayList.get(i)).idx, ((ColumnData)arrayList.get(i + 1)).idx - 1) : string2.substring(((ColumnData)arrayList.get(i)).idx);
                rowData.add(((ColumnData)arrayList.get((int)i)).name, string3.trim());
            }
            arrayList2.add(rowData);
        }
        scanner.close();
        return arrayList2;
    }

    private static void parseNextColumn(List<ColumnData> list, String string, int n) {
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n3 = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c == ' ') {
                if (n3 == 2) break;
                stringBuffer.append(cArray[n]);
                ++n3;
            } else {
                n3 = 0;
                stringBuffer.append(cArray[n]);
            }
            ++n;
        }
        while (n < cArray.length && cArray[n] == ' ') {
            ++n;
        }
        list.add(new ColumnData(stringBuffer.toString().trim(), n2));
        if (n < cArray.length) {
            CommandUtil.parseNextColumn(list, string, n);
        }
    }

    public static RowData parseRowValues(String string) {
        Scanner scanner = new Scanner(string);
        RowData rowData = new RowData();
        while (scanner.hasNextLine()) {
            int n;
            String string2 = scanner.nextLine().trim();
            if (string2.length() <= 0 || (n = string2.indexOf(":")) <= -1) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1);
            rowData.add(string3.trim(), string4.trim());
        }
        scanner.close();
        return rowData;
    }

    public static class ColumnData {
        public String name;
        private String value;
        private int idx = -1;

        ColumnData(String string, int n) {
            this(string, null);
            this.idx = n;
        }

        ColumnData(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }

    public static class RowData {
        public List<ColumnData> columns = new ArrayList<ColumnData>();

        public void add(String string, String string2) {
            ColumnData columnData = new ColumnData(string, string2);
            this.columns.add(columnData);
        }

        private void set(String string, String string2) {
            ColumnData columnData = this.findColumn(string);
            if (columnData != null) {
                columnData.value = string2;
            }
        }

        private ColumnData findColumn(String string) {
            for (ColumnData columnData : this.columns) {
                if (!columnData.name.equalsIgnoreCase(string)) continue;
                return columnData;
            }
            return null;
        }

        public String getColumn(String string) {
            ColumnData columnData = this.findColumn(string);
            if (columnData != null) {
                return columnData.value;
            }
            return null;
        }
    }
}

