/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.cmd;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.WorkflowRegistry;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.StreamGobbler;
import commvault.cte.workflow.utils.WorkflowUtils;
import java.io.File;
import java.io.IOException;

public abstract class CommandActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(CommandActivity.class);
    @Output(documentation="return code from the executable")
    public int exitCode;
    @Output(documentation="command output")
    public String commandOutput;

    protected String execute(StringBuffer stringBuffer, ActivityContext activityContext) throws InterruptedException, EvFailureException {
        return this.execute(stringBuffer.toString(), activityContext, false);
    }

    protected String execute(String string, ActivityContext activityContext) throws InterruptedException, EvFailureException {
        return this.execute(string, activityContext, false);
    }

    protected String execute(StringBuffer stringBuffer, ActivityContext activityContext, boolean bl) throws InterruptedException, EvFailureException {
        return this.execute(stringBuffer.toString(), activityContext, bl);
    }

    protected String execute(String string, ActivityContext activityContext, boolean bl) throws InterruptedException, EvFailureException {
        return this.executeJava(string, activityContext, bl);
    }

    protected String executeJava(String string, ActivityContext activityContext, boolean bl) throws InterruptedException, EvFailureException {
        File file = new File(WorkflowRegistry.getInstance().getGalaxyHome(), "Base");
        if (!WorkflowUtils.isWindows()) {
            string = file.getAbsolutePath() + "/" + string;
        }
        if (bl) {
            logger.trace(Long.valueOf(activityContext.getJobId()), "executing command [%s]", new Object[]{this.getCommandToLog(string)});
        } else {
            logger.info(Long.valueOf(activityContext.getJobId()), "executing command [%s]", new Object[]{this.getCommandToLog(string)});
        }
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(string);
        }
        catch (IOException iOException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "error executing command [" + this.getCommandToLog(string) + "]", (Throwable)iOException);
            throw new EvFailureException(new EvMessageContainer(iOException.getMessage()));
        }
        StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream(), "ERROR");
        StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream(), "OUTPUT");
        streamGobbler.start();
        streamGobbler2.start();
        this.exitCode = process.waitFor();
        streamGobbler.join();
        streamGobbler2.join();
        if (this.exitCode == 0) {
            this.commandOutput = streamGobbler2.getBuffer().toString().trim();
            if (bl) {
                logger.trace(Long.valueOf(activityContext.getJobId()), "command succeeded with result [%s]", new Object[]{this.commandOutput});
            } else {
                logger.info(Long.valueOf(activityContext.getJobId()), "command succeeded with result [%s]", new Object[]{this.commandOutput});
            }
        } else {
            EvMessageContainer evMessageContainer;
            String string2 = streamGobbler.getBuffer().toString().trim();
            if (string2.length() > 0) {
                this.commandOutput = string2;
                evMessageContainer = new EvMessageContainer(string2);
            } else {
                this.commandOutput = streamGobbler2.getBuffer().toString().trim();
                evMessageContainer = new EvMessageContainer("execution of command resulted in exitCode [%s]", new Object[]{this.exitCode});
            }
            logger.error(Long.valueOf(activityContext.getJobId()), "command exited with code [" + this.exitCode + "], error [" + string2 + "]");
            WorkflowUtils.closeProcess((Process)process);
            throw new EvFailureException(evMessageContainer);
        }
        WorkflowUtils.closeProcess((Process)process);
        return this.commandOutput;
    }

    protected String getCommandToLog(String string) {
        return string;
    }
}

