/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.xml.CTEProcessingModel;
import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.common.xml.XMLEncoder;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.SessionManager;
import commvault.cte.workflow.WorkflowContext;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.XMLInput;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.DebugHelper;
import commvault.cte.workflow.utils.WorkflowUtils;
import commvault.msgs.Workflow.DebugWorkflowInputsResp;
import commvault.msgs.Workflow.DebugWorkflowResp;
import commvault.msgs.Workflow.GetWorkflowInputsResp;
import commvault.msgs.Workflow.InputForm;
import workflow.types.XML;

public class WorkflowInputsActivity
implements Activity,
XMLInput {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(WorkflowInputsActivity.class);
    private String inputs;
    private String formProperties;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        InputForm inputForm;
        WorkflowElement workflowElement;
        try {
            workflowElement = WorkflowElement.parse((String)this.inputs);
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse input xml");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        try {
            inputForm = this.parse(new WorkflowEvaluator(activityContext.getEvaluator()), WorkflowUtils.getUserInputForm((ActivityContext)activityContext, (XML)workflowElement, (String)this.formProperties));
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to build input form");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        DebugWorkflowInputsResp debugWorkflowInputsResp = null;
        if (activityContext.isDebug()) {
            debugWorkflowInputsResp = new DebugWorkflowInputsResp();
            try {
                DebugHelper.buildThreadResponse((DebugWorkflowResp)debugWorkflowInputsResp, (ActivityContext)activityContext);
                debugWorkflowInputsResp.setInputForm(inputForm);
            }
            catch (Exception exception) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to build debug response", (Throwable)exception);
            }
        }
        if (debugWorkflowInputsResp == null) {
            debugWorkflowInputsResp = new GetWorkflowInputsResp();
            ((GetWorkflowInputsResp)debugWorkflowInputsResp).setInputForm(inputForm);
        }
        SessionManager.getInstance().close((WorkflowContext)activityContext, (CTEProcessingModel)debugWorkflowInputsResp);
        return AttemptStatus.SUCCESS;
    }

    private InputForm parse(WorkflowEvaluator workflowEvaluator, InputForm inputForm) {
        try {
            String string = XMLEncoder.encode((Object)inputForm);
            String string2 = workflowEvaluator.parseString(string, true);
            return (InputForm)XMLDecoder.decode((String)string2, (Object)new InputForm());
        }
        catch (Exception exception) {
            logger.error("failed to update xpath entries in xml", (Throwable)exception);
            return inputForm;
        }
    }

    public void setInputs(String string) {
        this.inputs = string;
    }
}

