/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.VMUtilities;

import commvault.cte.db.CTEDBException;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.SecurityContext;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activities.VMUtilities.VMOperationType;
import commvault.cte.workflow.db.DatabaseQuery;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.XMLQuery;
import commvault.msgs.CvEntities.ClientEntity;
import workflow.types.EncryptedString;
import workflow.types.SimpleType;
import workflow.types.data.DataSet;

public class VMUtilHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(VMUtilHandler.class);
    public String outputXml;
    public String commandArgs;
    public String xpath;
    public SimpleType outputType;
    public Boolean outputAsList;
    public Object result;
    public EncryptedString vmPassword;

    public String prepareCloneVMTaskXML(ActivityContext activityContext, String string, String string2, String string3, ClientEntity clientEntity, String string4, String string5, String string6, VMOperationType vMOperationType, String string7) {
        StringBuffer stringBuffer = new StringBuffer();
        if (clientEntity == null) {
            clientEntity = new ClientEntity();
        }
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuffer.append("<TMMsg_CreateTaskReq>");
        stringBuffer.append("<taskInfo>");
        stringBuffer.append("<task>").append("<taskFlags disabled=\"0\"/>").append("</task>");
        stringBuffer.append("<subTasks>");
        stringBuffer.append("<subTask subTaskType=\"1\" operationType=\"4038\" />");
        stringBuffer.append("<options>");
        stringBuffer.append("<adminOpts>");
        stringBuffer.append(String.format("<vmProvisioningOption operationType=\"%s\">", vMOperationType.getEnumValue()));
        stringBuffer.append("<virtualMachineOption>");
        stringBuffer.append(String.format("<vmAllocPolicy vmAllocPolicyName=\"%s\"  />", string4));
        stringBuffer.append(String.format("<vmEntity hostName=\"\" vmName=\"%s\" clientId=\"%s\" clientName=\"%s\" vmGUID=\"%s\" />", string, clientEntity.getClientId(), clientEntity.getClientName(), string2));
        stringBuffer.append(String.format("<password password=\"%s\"></password>", string6));
        if (string7 != null && !string7.isEmpty()) {
            stringBuffer.append("<vmInfo numberOfNICs=\"1\">").append(String.format("<advancedProperties additionalFlags=\"0\" ><networkCards label=\"Network adapter 1\" networkName=\"%s\"></networkCards></advancedProperties>", string7));
        } else {
            stringBuffer.append("<vmInfo>");
        }
        stringBuffer.append("<expirationTime time=\"\" />");
        stringBuffer.append(String.format("<vm vmName=\"%s\" />", string3)).append(String.format("<vmLocation hostName=\"%s\"/>", string5)).append("</vmInfo>");
        stringBuffer.append("</virtualMachineOption>");
        stringBuffer.append("</vmProvisioningOption>");
        stringBuffer.append("</adminOpts>");
        stringBuffer.append("</options>");
        stringBuffer.append("</subTasks>");
        stringBuffer.append("</taskInfo>");
        stringBuffer.append("</TMMsg_CreateTaskReq>");
        return stringBuffer.toString();
    }

    public String prepareNetworkOperationsXML(ActivityContext activityContext, VMOperationType vMOperationType, String string, String string2, ClientEntity clientEntity) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?><TMMsg_VMProvisioningOption operationType=\"%s\">", vMOperationType.getEnumValue()));
        stringBuffer.append(String.format("<networkOption hostName=\"%s\"><network  networkName=\"%s\" />", string, string2));
        stringBuffer.append(String.format("<location><virtualizationClient clientName=\"%s\" clientId= \"%s\" /></location></networkOption></TMMsg_VMProvisioningOption>", clientEntity.getClientName(), clientEntity.getClientId()));
        return stringBuffer.toString();
    }

    public String prepareAttachOrDeAttachNetworkXML(ActivityContext activityContext, String string, String string2, ClientEntity clientEntity, VMOperationType vMOperationType, ClientEntity clientEntity2, String string3) {
        return this.prepareAttachOrDeAttachNetworkXML(activityContext, string, string2, clientEntity, vMOperationType, clientEntity2, string3, null);
    }

    public String prepareAttachOrDeAttachNetworkXML(ActivityContext activityContext, String string, String string2, ClientEntity clientEntity, VMOperationType vMOperationType, ClientEntity clientEntity2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?><TMMsg_VMProvisioningOption operationType=\"%s\">", vMOperationType.getEnumValue()));
        if (string4 != null && !string4.isEmpty()) {
            stringBuffer.append(String.format("<networkOption><network  macAddress=\"%s\" networkName=\"%s\" /> </networkOption>", string4, string3));
        } else {
            stringBuffer.append(String.format("<networkOption><network  networkName=\"%s\" /> </networkOption>", string3));
        }
        stringBuffer.append("<virtualMachineOption flags=\"1\">");
        stringBuffer.append(String.format("<vmInfo><vm vmName=\"%s\" vmGUID=\"%s\" clientName=\"%s\" clientId= \"%s\"></vm><vmLocation><virtualizationClient clientName=\"%s\" clientId= \"%s\" /></vmLocation>", string, string2, clientEntity.getClientName(), clientEntity.getClientId(), clientEntity2.getClientName(), clientEntity2.getClientId()));
        stringBuffer.append("</vmInfo></virtualMachineOption></TMMsg_VMProvisioningOption>");
        return stringBuffer.toString();
    }

    public String prepareVMOperationsXML(ActivityContext activityContext, String string, String string2, ClientEntity clientEntity, VMOperationType vMOperationType, ClientEntity clientEntity2, String string3, boolean bl, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("<?xml version=\"1.0\" encoding=\"utf-8\"?><TMMsg_VMProvisioningOption operationType=\"%s\">", vMOperationType.getEnumValue()));
        if (bl) {
            stringBuffer.append(String.format("<virtualMachineOption jobId =\"%s\" flags=\"1\">", activityContext.getJobId()));
        } else {
            stringBuffer.append("<virtualMachineOption jobId =\"0\" flags=\"0\">");
        }
        stringBuffer.append(String.format("<vmInfo vmAllocPolicyId=\"-1\"><vm vmName=\"%s\" vmGUID=\"%s\" clientName=\"%s\" clientId= \"%s\"></vm><vmLocation><virtualizationClient clientName=\"%s\" clientId= \"%s\" /></vmLocation>", string, string2, clientEntity.getClientName(), clientEntity.getClientId(), clientEntity2.getClientName(), clientEntity2.getClientId()));
        if (vMOperationType == VMOperationType.RENEW_VM) {
            stringBuffer.append(String.format("<expirationTime><timeValue>%s</timeValue></expirationTime>", string3));
        }
        if (vMOperationType == VMOperationType.EXEC_GUEST_SCRIPT) {
            stringBuffer.append("<advancedProperties>");
            stringBuffer.append(string4);
            stringBuffer.append("</advancedProperties>");
        }
        stringBuffer.append("</vmInfo></virtualMachineOption></TMMsg_VMProvisioningOption>");
        return stringBuffer.toString();
    }

    public String prepareVMOperationsXML(ActivityContext activityContext, String string, String string2, ClientEntity clientEntity, VMOperationType vMOperationType, ClientEntity clientEntity2, String string3, boolean bl) {
        return this.prepareVMOperationsXML(activityContext, string, string2, clientEntity, vMOperationType, clientEntity2, string3, true, "");
    }

    public String prepareVMOperationsXML(ActivityContext activityContext, String string, String string2, ClientEntity clientEntity, VMOperationType vMOperationType, ClientEntity clientEntity2, String string3) {
        return this.prepareVMOperationsXML(activityContext, string, string2, clientEntity, vMOperationType, clientEntity2, string3, true);
    }

    public String prepareGuestScriptOperationXML(String string, String string2, ClientEntity clientEntity, int n, int n2, String string3, EncryptedString encryptedString, String string4, EncryptedString encryptedString2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("<guestScript scriptPath=\"%s\" isUNC=\"%s\" timeOutSeconds=\"%s\" scriptLog=\"%s\">", string, n, n2, string2));
        if (clientEntity != null) {
            stringBuffer.append(String.format("<clientDetails clientId=\"%s\" clientName=\"%s\" />", clientEntity.getClientId(), clientEntity.getClientName()));
        }
        if (n == 1) {
            stringBuffer.append(String.format("<UNCCredentials confirmPassword=\"%s\" password=\"%s\" userName=\"%s\" />", encryptedString2.getPlainText(), encryptedString2.getPlainText(), string4));
        }
        stringBuffer.append(String.format("<guestCredentials confirmPassword=\"%s\" password=\"%s\" userName=\"%s\" />", encryptedString.getPlainText(), encryptedString.getPlainText(), string3));
        stringBuffer.append("</guestScript>");
        return stringBuffer.toString();
    }

    public DataSet queryExecution(String string, ActivityContext activityContext) throws EvFailureException {
        DataSet dataSet;
        DatabaseQuery databaseQuery = new DatabaseQuery((SecurityContext)activityContext.getContext(), WorkflowProperties.getInstance().getCommCellConnection());
        logger.trace(Long.valueOf(activityContext.getJobId()), "begin execution of csdb query [%s]", new Object[]{string});
        try {
            dataSet = databaseQuery.execute(string);
        }
        catch (CTEDBException cTEDBException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to execute query [" + string + "]", (Throwable)cTEDBException);
            throw new EvFailureException(new EvMessageContainer(cTEDBException.getMessage()));
        }
        if (dataSet.hasNext()) {
            logger.info(Long.valueOf(activityContext.getJobId()), "csdb query returned value [%s]", new Object[]{dataSet.get(0)});
            return dataSet;
        }
        logger.error(Long.valueOf(activityContext.getJobId()), "query [" + string + "] did not return a result");
        return null;
    }

    public Object parseoutputXml(String string, String string2, Boolean bl, SimpleType simpleType) throws InterruptedException {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string2 == null || string2.length() == 0) {
            return null;
        }
        if (bl == null) {
            bl = true;
        }
        if (this.outputType == null) {
            this.outputType = SimpleType.String;
        }
        try {
            this.result = XMLQuery.query((String)string, (String)string2, (SimpleType)this.outputType, (boolean)bl);
        }
        catch (EvFailureException evFailureException) {
            return null;
        }
        return this.result;
    }
}

