/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities.VMUtilities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activities.VMUtilities.VMOperationType;
import commvault.cte.workflow.activities.VMUtilities.VMOperationsHandler;
import commvault.cte.workflow.activities.VMUtilities.VMUtilHandler;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;

public class PowerOn
extends VMOperationsHandler {
    private static final long serialVersionUID = 1L;
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(PowerOn.class);
    @Input(documentation="The Virtual Machine Client Name", required=false)
    public ClientEntity vmClientName;
    @Input(documentation="The Virtual Machine Name", required=false)
    public String vmName;
    @Input(documentation="The Virtual Machine GUID", required=false)
    public String vmGUID;
    @Input(documentation="The Virtualization Client Name", required=true)
    public ClientEntity virtualizationClient;
    @Input(documentation="The WaitForPowerOnComplete", required=false)
    public boolean waitForPowerOnComplete = false;
    @Output(documentation="return vm operations error code")
    public int errorCode;
    @Output(documentation="return vm operations error message")
    public String errorMessage;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        String string = "";
        VMUtilHandler vMUtilHandler = new VMUtilHandler();
        if (this.virtualizationClient != null && this.virtualizationClient.getClientName().length() > 0) {
            if (this.vmClientName != null || this.vmGUID.length() > 0) {
                string = vMUtilHandler.prepareVMOperationsXML(activityContext, this.vmName, this.vmGUID, this.vmClientName, VMOperationType.POWERON_VM, this.virtualizationClient, "", this.waitForPowerOnComplete);
                AttemptStatus attemptStatus = super.executeVMOperation(string, activityContext);
                if (attemptStatus == AttemptStatus.SUCCESS && this.errCode != 0) {
                    String string2;
                    this.errorMessage = string2 = String.format("VM [%s] failed to Power On . Error[%s]", this.vmName, this.errMsg);
                    this.errorCode = this.errCode;
                    logger.error(string2);
                    activityContext.setFailureReason(string2);
                    return AttemptStatus.FAILED;
                }
                return attemptStatus;
            }
            String string3 = String.format("Unable to perform Power On Operation, some of the inputs are not specified. Hint: Please provide either VM ClientName or VM GUID & VM Name", new Object[0]);
            logger.error(string3);
            activityContext.setFailureReason(string3);
            return AttemptStatus.FAILED;
        }
        String string4 = String.format("Unable to perform Power On Operation, virtualization client name is not provided", new Object[0]);
        logger.error(string4);
        activityContext.setFailureReason(string4);
        return AttemptStatus.FAILED;
    }
}

