/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.logger.CTELogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import workflow.types.Delimiter;
import workflow.types.data.DataRow;
import workflow.types.data.DataSet;
import workflow.types.data.MetaData;

public class TextToResultSet
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(TextToResultSet.class);
    @Input
    public String text;
    @Input(defaultValue="Comma")
    public Delimiter delimiter;
    @Input(defaultValue="false")
    public boolean headers;
    @Output
    public DataSet resultSet;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        this.resultSet = new DataSet();
        if (this.text == null || this.text.length() == 0) {
            return AttemptStatus.SUCCESS;
        }
        MetaData metaData = null;
        int n = 0;
        Scanner scanner = new Scanner(this.text);
        while (scanner.hasNextLine()) {
            String string = scanner.nextLine();
            Object[] objectArray = StringUtils.splitPreserveAllTokens((String)string, (char)this.delimiter.getDelimiter());
            if (metaData == null) {
                if (this.headers) {
                    metaData = new MetaData((String[])objectArray);
                    n = objectArray.length;
                    continue;
                }
                ArrayList<MetaData.ColumnData> arrayList = new ArrayList<MetaData.ColumnData>();
                for (int i = 0; i < objectArray.length; ++i) {
                    arrayList.add(new MetaData.ColumnData("", i));
                }
                metaData = new MetaData(arrayList);
                n = objectArray.length;
            }
            if (objectArray.length > n) {
                logger.warn(Long.valueOf(activityContext.getJobId()), "found row in text result that is greater then the meta size of [" + n + "], row:\n" + string);
                this.resultSet.add(new DataRow(metaData, Arrays.copyOf(objectArray, n)));
                continue;
            }
            this.resultSet.add(new DataRow(metaData, objectArray));
        }
        scanner.close();
        return AttemptStatus.SUCCESS;
    }
}

