/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.common.xml.XMLDecoder;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.activity.ExpressionHandler;
import commvault.cte.workflow.activity.XMLInput;
import commvault.cte.workflow.annotations.Output;
import commvault.cte.workflow.dom.WorkflowElement;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.Workflow.ScriptDefinition;
import javax.xml.stream.XMLStreamReader;

public class ScriptActivity
implements Activity,
XMLInput,
ExpressionHandler {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ScriptActivity.class);
    private String xml;
    @Output
    public Object output;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        ScriptDefinition scriptDefinition;
        WorkflowElement workflowElement;
        try {
            workflowElement = WorkflowElement.parse((String)this.xml);
        }
        catch (EvFailureException evFailureException) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to parse input xml [" + this.xml + "]");
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        WorkflowElement workflowElement2 = workflowElement.getChild("script");
        if (workflowElement2 == null) {
            logger.warn(Long.valueOf(activityContext.getJobId()), "could not find script element");
            return AttemptStatus.SUCCESS;
        }
        try {
            scriptDefinition = (ScriptDefinition)XMLDecoder.decode((XMLStreamReader)new commvault.cte.workflow.dom.XMLStreamReader(workflowElement2), (Object)new ScriptDefinition());
        }
        catch (Exception exception) {
            logger.error(Long.valueOf(activityContext.getJobId()), "failed to decode script definition [" + workflowElement2 + "]", (Throwable)exception);
            activityContext.setFailureReason(new EvMessageContainer(exception.getMessage()));
            return AttemptStatus.FAILED;
        }
        try {
            this.output = activityContext.getEvaluator().evaluate(scriptDefinition);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
        if (this.output == null) {
            logger.debug(Long.valueOf(activityContext.getJobId()), "script activity did not return a value");
        } else {
            logger.info(Long.valueOf(activityContext.getJobId()), "script activity returned value [%s]", new Object[]{String.valueOf(this.output)});
        }
        return AttemptStatus.SUCCESS;
    }

    public void processExpressions(ActivityContext activityContext, WorkflowElement workflowElement) {
    }

    public void setInputs(String string) {
        this.xml = string;
    }
}

