/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.db.CTEDBReservation;
import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.WorkflowProperties;
import commvault.cte.workflow.activities.CommandActivity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.CvEntities.ClientEntity;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class RestartServicesActivity
extends CommandActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(RestartServicesActivity.class);
    @Input(documentation="the remote host to restart the services on")
    public ClientEntity client;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        String string;
        String string2;
        String string3;
        String string4 = this.client != null && this.client.getClientName().length() > 0 ? this.client.getClientName() : WorkflowProperties.getInstance().getClient().getClientName();
        try {
            string3 = this.getOSType(string4);
        }
        catch (Exception exception) {
            logger.error("failed to retrieve os type for client [" + string4 + "]", (Throwable)exception);
            string3 = "Windows";
        }
        if (string3.equalsIgnoreCase("Unix")) {
            string2 = "commvault";
            string = "restart";
        } else {
            string2 = "gxadmin";
            string = "-console -restartsvcgrp All";
        }
        try {
            return this.executeCommand(activityContext, string4, null, null, "", string2, "", null, string, true);
        }
        catch (EvFailureException evFailureException) {
            activityContext.setFailureReason(evFailureException.getMessageContainer());
            return AttemptStatus.FAILED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOSType(String string) throws Exception {
        try (CTEDBReservation cTEDBReservation = WorkflowProperties.getInstance().getCommCellConnection().createReservation();){
            PreparedStatement preparedStatement = cTEDBReservation.createStatement("select ISNULL(o.type, 'Windows') As OSType From APP_Client c LEFT OUTER JOIN simOperatingSystem o ON c.simOperatingSystemId = o.id Where c.name = ?");
            preparedStatement.setString(1, string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString(1);
                return string2;
            }
            String string3 = "Windows";
            return string3;
        }
    }
}

