/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.AttemptStatus;
import commvault.cte.workflow.EvMessageContainer;
import commvault.cte.workflow.activity.Activity;
import commvault.cte.workflow.annotations.Input;
import commvault.cte.workflow.logger.CTELogger;
import commvault.msgs.App.EventSeverity;
import workflow.types.SeverityLevel;

public class LogEventActivity
implements Activity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(LogEventActivity.class);
    @Input(documentation="the severity of the event", defaultValue="INFO")
    public SeverityLevel severity;
    @Input(documentation="the event message")
    public String message;

    public AttemptStatus execute(ActivityContext activityContext) throws InterruptedException {
        EventSeverity eventSeverity;
        if (this.severity == null) {
            this.severity = SeverityLevel.INFO;
        }
        switch (this.severity) {
            case INFO: {
                eventSeverity = EventSeverity.INFO;
                break;
            }
            case MINOR: {
                eventSeverity = EventSeverity.MINOR;
                break;
            }
            case MAJOR: {
                eventSeverity = EventSeverity.MAJOR;
                break;
            }
            case CRITICAL: {
                eventSeverity = EventSeverity.CRITICAL;
                break;
            }
            default: {
                logger.warn(Long.valueOf(activityContext.getJobId()), "unable to determine Workflow::EventSeverity from inputted severity [%s]", new Object[]{this.severity.toString()});
                eventSeverity = EventSeverity.INFO;
            }
        }
        logger.info(Long.valueOf(activityContext.getJobId()), "generating event with severity level [%s], message [%s]", new Object[]{eventSeverity.toString(), this.message});
        EvMessageContainer evMessageContainer = new EvMessageContainer(this.message);
        activityContext.getJobManager().writeEvent(eventSeverity, evMessageContainer);
        return AttemptStatus.SUCCESS;
    }
}

