/*
 * Decompiled with CFR 0.152.
 */
package commvault.cte.workflow.activities;

import commvault.cte.workflow.ActivityContext;
import commvault.cte.workflow.EvFailureException;
import commvault.cte.workflow.activities.ListActivity;
import commvault.cte.workflow.eval.ExpressionUtils;
import commvault.cte.workflow.eval.WorkflowEvaluator;
import commvault.cte.workflow.logger.CTELogger;
import commvault.cte.workflow.utils.WorkflowUtils;
import java.util.List;

public abstract class ListItemActivity
extends ListActivity {
    private static final CTELogger.LoggerInstance logger = CTELogger.getLogger(ListItemActivity.class);
    protected Object itemObject;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void decodeItem(ActivityContext activityContext, Object object, boolean bl) throws EvFailureException {
        String string = String.valueOf(object);
        if (ExpressionUtils.isObjectExpression((String)string)) {
            try {
                Object object2 = activityContext.getEvaluator().evaluate(string);
                if (object2 instanceof List) {
                    List list = (List)object2;
                    if (bl && list.size() > 1) {
                        this.itemObject = object2;
                        return;
                    }
                    if (list.size() != 1) return;
                    this.itemObject = this.convertValueToType(activityContext, list.get(0));
                    return;
                }
                this.itemObject = this.convertValueToType(activityContext, object2);
                return;
            }
            catch (EvFailureException evFailureException) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to retrieve item to add via expression [" + string + "]");
                throw evFailureException;
            }
        } else {
            this.itemObject = this.convertValueToType(activityContext, string);
        }
    }

    private Object convertValueToType(ActivityContext activityContext, Object object) throws EvFailureException {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            WorkflowEvaluator workflowEvaluator = new WorkflowEvaluator(activityContext.getEvaluator());
            object = workflowEvaluator.parseString(object.toString());
        }
        if (this.type != null) {
            try {
                return WorkflowUtils.convert((String)String.valueOf(object), (Class)this.type);
            }
            catch (Exception exception) {
                logger.error(Long.valueOf(activityContext.getJobId()), "failed to convert value [" + object + "] to type [" + this.type + "]");
                return object;
            }
        }
        return object;
    }
}

